/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.generated.snowflake;

import com.dataiku.dss.shadelib.com.google.gson.stream.JsonReader;
import com.dataiku.scoring.Observation;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Scanner;

public class SnowflakeBaseModel {
    public SnowflakeBaseModel() {
        File importDirectory = new File(System.getProperty("com.snowflake.import_directory"));
        try (Scanner applicationStringScanner = new Scanner(new File(importDirectory, "dataiku-app-str.txt"));){
            System.setProperty("com.snowflake.partner_attribution", applicationStringScanner.nextLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Observation observationFromInput(String input, Observation.Builder obsBuilder) throws Exception {
        try (JsonReader obj = new JsonReader((Reader)new StringReader(input));){
            obj.setLenient(true);
            obj.beginObject();
            block11: while (obj.hasNext()) {
                String name = obj.nextName();
                switch (obj.peek()) {
                    case NUMBER: {
                        obsBuilder.with(name, obj.nextDouble());
                        continue block11;
                    }
                    case STRING: {
                        obsBuilder.with(name, obj.nextString());
                        continue block11;
                    }
                    case BOOLEAN: {
                        obsBuilder.with(name, Boolean.toString(obj.nextBoolean()));
                        continue block11;
                    }
                    case NULL: {
                        obsBuilder.with(name, (String)null);
                        obj.nextNull();
                        continue block11;
                    }
                }
                obj.skipValue();
            }
            obj.endObject();
        }
        return obsBuilder.build();
    }
}

