/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.linalg;

import com.dataiku.scoring.linalg.Vector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparseVector
implements Vector {
    private static final long serialVersionUID = 0L;
    private final Map<Integer, Double> data;
    private final int size;

    public SparseVector(Map<Integer, Double> data, int size) {
        this.data = data;
        this.size = size;
    }

    public SparseVector(int[] indices, double[] values, int size) {
        if (indices.length != values.length) {
            throw new IllegalArgumentException("Indices and values must have same length.");
        }
        this.size = size;
        this.data = new HashMap<Integer, Double>();
        for (int i = 0; i < indices.length; ++i) {
            this.data.put(indices[i], values[i]);
        }
    }

    public SparseVector(double[] dense) {
        this.size = dense.length;
        this.data = new HashMap<Integer, Double>();
        for (int i = 0; i < this.size; ++i) {
            this.data.put(i, dense[i]);
        }
    }

    @Override
    public double get(int i) {
        Double res = this.data.get(i);
        if (res == null) {
            return 0.0;
        }
        return res;
    }

    @Override
    public Iterable<Integer> activeIndices() {
        return this.data.keySet();
    }

    @Override
    public boolean isActive(int i) {
        return this.data.containsKey(i);
    }

    @Override
    public boolean isMissing(int i) {
        return this.data.containsKey(i) && (this.data.get(i) == null || Double.isNaN(this.data.get(i)));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double[] toArray() {
        double[] dat = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dat[i] = this.get(i);
        }
        return dat;
    }

    @Override
    public List<Double> toList() {
        ArrayList<Double> dat = new ArrayList<Double>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            dat.add(this.get(i));
        }
        return dat;
    }
}

