/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.tuple.Pair;
import com.dataiku.scoring.Try;
import com.dataiku.scoring.pipelines.Pipeline;
import com.dataiku.scoring.pipelines.PreprocessingPipeline;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.pipelines.overrides.OverridesLayerBase;
import com.dataiku.scoring.util.RawObservation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractPipeline<M, PT, Y extends Result<PT>>
implements Serializable,
Pipeline<PT, Y> {
    private static final long serialVersionUID = 0L;
    protected final PreprocessingPipeline preprocessing;
    protected final M model;
    protected final OverridesLayerBase<Y> overridesLayer;
    boolean initialized = false;
    protected final List<ColumnComputer<?, PT, Y>> columnComputers = new ArrayList();

    public AbstractPipeline(PreprocessingPipeline preprocessing, M model, OverridesLayerBase<Y> overridesLayer, Class<PT> predictionColumnType) {
        this.preprocessing = preprocessing;
        this.model = model;
        this.overridesLayer = overridesLayer;
        this.columnComputers.add(new PredictionComputer(predictionColumnType));
        if (overridesLayer != null) {
            this.columnComputers.add(new OverrideColumnComputer());
        }
    }

    @Override
    public void init() {
        if (this.overridesLayer != null) {
            this.overridesLayer.init();
        }
        this.initialized = true;
    }

    void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("pipeline is not initialized");
        }
    }

    public boolean requiresPostPredict() {
        return this.hasOverrides();
    }

    @Override
    public boolean hasOverrides() {
        return this.overridesLayer != null;
    }

    public RawObservation copyRawObservationForPostPredictIfNeededOrNull(RawObservation r) {
        if (!this.requiresPostPredict()) {
            return null;
        }
        return r.copy();
    }

    @Override
    public PreprocessingPipeline getPreprocessing() {
        return this.preprocessing;
    }

    public M getModel() {
        return this.model;
    }

    protected Try<Y> postPredict(RawObservation r, Y rawResult) {
        this.checkInitialized();
        if (this.requiresPostPredict()) {
            assert (r != null);
            return this.overridesLayer.apply(r, rawResult);
        }
        return Try.success(rawResult);
    }

    @Override
    public List<Pair<String, Class<Object>>> getComputedColumnsTypes(@Nullable List<String> columnsWhitelist) {
        return this.columnComputers.stream().filter(c -> columnsWhitelist == null || columnsWhitelist.contains(c.getColumnName())).map(c -> Pair.of((Object)c.getColumnName(), c.getOutputClass())).collect(Collectors.toList());
    }

    @Override
    public List<Pair<String, Optional<Object>>> getComputedColumnsValues(RawObservation rawObservation, Y result, @Nullable List<String> columnsWhitelist) {
        return this.columnComputers.stream().filter(c -> columnsWhitelist == null || columnsWhitelist.contains(c.getColumnName())).map(c -> Pair.of((Object)c.getColumnName(), c.getOutputValue(result))).collect(Collectors.toList());
    }

    public static class PredictionComputer<PT, Y extends Result<PT>>
    extends AbstractColumnComputer<PT, PT, Y> {
        public static String COLUMN_NAME = "prediction";

        public PredictionComputer(Class<PT> predictionColumnType) {
            super(COLUMN_NAME, predictionColumnType);
        }

        @Override
        public Optional<PT> getOutputValue(Y result) {
            if (((Result)result).isDeclined()) {
                return Optional.empty();
            }
            return Optional.of(((Result)result).getPrediction());
        }
    }

    public static class OverrideColumnComputer<PT, Y extends Result<PT>>
    extends AbstractColumnComputer<String, PT, Y> {
        public static String COLUMN_NAME = "override";

        public OverrideColumnComputer() {
            super(COLUMN_NAME, String.class);
        }

        @Override
        public Optional<String> getOutputValue(Y result) {
            if (!((Result)result).hasOverrideInfo()) {
                return Optional.empty();
            }
            return Optional.of(((Result)result).getOverrideInfoAsJson());
        }
    }

    public static interface ColumnComputer<T, PT, Y extends Result<PT>>
    extends Serializable {
        public Optional<T> getOutputValue(Y var1);

        public String getColumnName();

        public Class<T> getOutputClass();
    }

    public static abstract class AbstractColumnComputer<T, PT, Y extends Result<PT>>
    implements ColumnComputer<T, PT, Y> {
        private final String columnName;
        private final Class<T> outputClass;

        protected AbstractColumnComputer(String columnName, Class<T> outputClass) {
            this.columnName = columnName;
            this.outputClass = outputClass;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public Class<T> getOutputClass() {
            return this.outputClass;
        }
    }
}

