/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.stream;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.stream.DecodedInputStreamFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.partitioning.Partition;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public abstract class AutoEnrichedInputStream
implements EnrichedInputStream {
    private long size;
    private String desc;
    private String pathWithinProvider;
    private String filename;
    @Nonnull
    private LongSupplier lastModifiedSupplier;
    private Partition partition;

    protected abstract InputStream getBasicInputStream() throws IOException, InterruptedException, CodedException, DKUSecurityException;

    protected abstract InputStream getBasicHeadInputStream(long var1) throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public AutoEnrichedInputStream(long basicInputStreamSize, String pathWithinProvider, String filename, String desc, @Nonnull LongSupplier lastModifiedSupplier) {
        this.size = basicInputStreamSize;
        this.filename = filename;
        this.pathWithinProvider = pathWithinProvider;
        this.desc = desc;
        this.lastModifiedSupplier = lastModifiedSupplier;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public String desc() {
        return this.desc;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getPathWithinProvider() {
        return this.pathWithinProvider;
    }

    @Override
    @Nonnull
    public LongSupplier getLastModifiedSupplier() {
        return this.lastModifiedSupplier;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Map<String, String> metas() {
        return new HashMap<String, String>();
    }

    @Override
    public InputStream decompressedStream() throws IOException, InterruptedException, CodedException, DKUSecurityException {
        if (this.isArchive()) {
            ArchiveInputStream archiveStream = this.archiveContent();
            ArchiveEntry entry = archiveStream.getNextEntry();
            if (entry == null) {
                return null;
            }
            return archiveStream;
        }
        return new DecodedInputStreamFactory().addDecoding(this.getCompression(), this.getBasicInputStream());
    }

    @Override
    public InputStream decompressedHeadStream(long targetSize) throws IOException, InterruptedException, CodedException, DKUSecurityException {
        if (this.isArchive()) {
            ArchiveEntry entry;
            ArchiveInputStream archiveStream = this.archiveContent();
            do {
                if ((entry = archiveStream.getNextEntry()) != null) continue;
                return null;
            } while (entry.isDirectory());
            return archiveStream;
        }
        return new DecodedInputStreamFactory().addDecoding(this.getCompression(), this.getBasicHeadInputStream(targetSize));
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    @Override
    public EnrichedInputStream.Compression getCompression() {
        return EnrichedInputStream.Compression.getCompression(this.filename);
    }

    @Override
    public boolean isArchive() {
        if (this.filename == null) {
            return false;
        }
        String f = this.filename.toLowerCase(Locale.ENGLISH);
        return f.endsWith(".zip") || f.endsWith(".tar") || f.endsWith(".tar.gz") || f.endsWith(".tgz") || f.endsWith(".tar.bz2");
    }

    @Override
    public ArchiveInputStream archiveContent() throws IOException, InterruptedException, CodedException, DKUSecurityException {
        String f = this.filename.toLowerCase(Locale.ENGLISH);
        if (f.endsWith(".zip")) {
            return new ZipArchiveInputStream(this.getBasicInputStream());
        }
        if (f.endsWith(".tar")) {
            return new TarArchiveInputStream(this.getBasicInputStream());
        }
        if (f.endsWith(".tar.gz") || f.endsWith(".tgz")) {
            return new TarArchiveInputStream((InputStream)new GZIPInputStream(this.getBasicInputStream()));
        }
        if (f.endsWith(".tar.bz2")) {
            return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(this.getBasicInputStream()));
        }
        throw new IllegalArgumentException("archiveContent for " + this.filename);
    }

    @Override
    public InputStream rawStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getBasicInputStream();
    }

    @Override
    public InputStream rawHeadStream(long targetSize) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getBasicHeadInputStream(targetSize);
    }
}

