/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIField;
import com.dataiku.j2ts.annotations.UIIgnore;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@UIModel(extraFields={@UIField(name="type", value="'time'"), @UIField(name="params", value="{ period: TimeDimension.Period }", manualImports={Period.class})})
public class TimeDimension
extends Dimension {
    public static final String TYPE = "time";
    private static final Pattern DATETIME_PARTITION_ID = Pattern.compile("([0-9]{4})(-([0-9]{2})(-([0-9]{2})((-| |T)([0-9]{2})(:[0-9]{2}:[0-9]{2}.*)?)?)?)?");
    @UIIgnore
    public Period mappedPeriod;

    @Override
    public String getType() {
        return TYPE;
    }

    public static JsonObject serialize(TimeDimension dimension) {
        JsonObject json = new JsonObject();
        JsonObject params = new JsonObject();
        params.addProperty("period", dimension.mappedPeriod.toString());
        json.addProperty("name", dimension.name);
        json.add("params", (JsonElement)params);
        return json;
    }

    public static TimeDimension deserialize(JsonObject json) {
        String name;
        String string = name = json.has("name") ? json.get("name").getAsString() : "";
        if (name.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension name is required.");
        }
        JsonObject params = json.get("params").getAsJsonObject();
        if (!params.has("period")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning range is required for dimension " + name + ".");
        }
        String period = params.get("period").getAsString();
        return new TimeDimension(name, Period.parse(period));
    }

    public TimeDimension(String name, Period mappedPeriod) {
        super(name);
        this.mappedPeriod = mappedPeriod;
    }

    public boolean hasYear() {
        return true;
    }

    public boolean hasMonth() {
        return this.mappedPeriod != Period.YEAR;
    }

    public boolean hasDay() {
        return this.mappedPeriod != Period.YEAR && this.mappedPeriod != Period.MONTH;
    }

    public boolean hasHour() {
        return this.mappedPeriod != Period.YEAR && this.mappedPeriod != Period.MONTH && this.mappedPeriod != Period.DAY;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TimeDimension)) {
            return false;
        }
        TimeDimension tother = (TimeDimension)other;
        return tother.mappedPeriod.equals((Object)this.mappedPeriod);
    }

    protected DimensionValue getValueFromSymbolicDate(String date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        TimeDimensionValue timeDim = new TimeDimensionValue(this);
        if (this.mappedPeriod == Period.DAY && date.equals("PREVIOUS_DAY")) {
            cal.add(5, -1);
        } else if (!(this.mappedPeriod == Period.DAY && date.equals("CURRENT_DAY") || this.mappedPeriod == Period.MONTH && date.equals("CURRENT_MONTH"))) {
            if (this.mappedPeriod == Period.MONTH && date.equals("PREVIOUS_MONTH")) {
                cal.add(2, -1);
            } else if (this.mappedPeriod != Period.HOUR || !date.equals("CURRENT_HOUR")) {
                if (this.mappedPeriod == Period.HOUR && date.equals("PREVIOUS_HOUR")) {
                    cal.add(11, -1);
                } else if (this.mappedPeriod != Period.YEAR || !date.equals("CURRENT_YEAR")) {
                    if (this.mappedPeriod == Period.YEAR && date.equals("PREVIOUS_YEAR")) {
                        cal.add(1, -1);
                    } else {
                        throw new IllegalArgumentException("Unable to parse date: " + date);
                    }
                }
            }
        }
        timeDim.setCal(cal);
        return timeDim;
    }

    @Override
    public DimensionValue getValueFromId(String id) {
        if (id.equals("PREVIOUS_DAY") || id.equals("CURRENT_DAY") || id.equals("CURRENT_MONTH") || id.equals("PREVIOUS_MONTH") || id.equals("CURRENT_HOUR") || id.equals("PREVIOUS_HOUR") || id.equals("CURRENT_YEAR") || id.equals("PREVIOUS_YEAR")) {
            return this.getValueFromSymbolicDate(id);
        }
        Matcher idMatcher = DATETIME_PARTITION_ID.matcher(id);
        if (!idMatcher.matches()) {
            throw new IllegalArgumentException("Illegal time partitioning value : '" + id + "' with a " + this.mappedPeriod.toString() + " partitioning");
        }
        try {
            TimeDimensionValue timeDim = new TimeDimensionValue(this);
            switch (this.mappedPeriod) {
                case HOUR: {
                    timeDim.setHour(Integer.parseInt(idMatcher.group(8)));
                }
                case DAY: {
                    timeDim.setDay(Integer.parseInt(idMatcher.group(5)));
                }
                case MONTH: {
                    timeDim.setMonth(Integer.parseInt(idMatcher.group(3)));
                }
                case YEAR: {
                    timeDim.setYear(Integer.parseInt(idMatcher.group(1)));
                    break;
                }
                default: {
                    throw new Error("Never reached.");
                }
            }
            return timeDim;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal time partitioning value : '" + id + "' with a " + this.mappedPeriod.toString() + " partitioning");
        }
    }

    public DimensionValue getValueFromDate(Date d) {
        Calendar cal = DKUtils.getUTCCalendar();
        cal.setTime(d);
        return new TimeDimensionValue(this).withCal(cal);
    }

    @Override
    public List<DimensionValue> getValuesFromPattern(String pattern) {
        if (pattern.contains("/")) {
            String[] ids = pattern.split("/", 2);
            TimeDimensionValue first = (TimeDimensionValue)this.getValueFromId(ids[0]);
            TimeDimensionValue last = (TimeDimensionValue)this.getValueFromId(ids[1]);
            TimeDimensionValue current = first;
            ArrayList<DimensionValue> values = new ArrayList<DimensionValue>();
            while (current.compareTo(last) <= 0) {
                values.add(current);
                current = current.nextPeriod();
            }
            return values;
        }
        if (pattern.contains(",")) {
            String[] ids = pattern.split(",");
            ArrayList<DimensionValue> values = new ArrayList<DimensionValue>();
            for (String id : ids) {
                if (!StringUtils.isNotBlank((String)id)) continue;
                TimeDimensionValue value = (TimeDimensionValue)this.getValueFromId(id);
                values.add(value);
            }
            return values;
        }
        return Collections.singletonList(this.getValueFromId(pattern));
    }

    @Override
    public DimensionType toDimensionType() {
        switch (this.mappedPeriod) {
            case YEAR: {
                return DimensionType.YEAR;
            }
            case MONTH: {
                return DimensionType.MONTH;
            }
            case DAY: {
                return DimensionType.DAY;
            }
            case HOUR: {
                return DimensionType.HOUR;
            }
        }
        throw new IllegalArgumentException("Unsupported: " + String.valueOf(this));
    }

    @Override
    public int hashCode() {
        throw new Error("hashCode not designed");
    }

    public static enum Period {
        YEAR,
        MONTH,
        DAY,
        HOUR;


        public static Period parse(String in) {
            for (Period p : Period.values()) {
                if (!p.toString().toLowerCase().equalsIgnoreCase(in)) continue;
                return p;
            }
            throw ErrorContext.iae((String)("Invalid time period " + in));
        }

        public String pattern() {
            switch (this) {
                case YEAR: {
                    return "%Y";
                }
                case MONTH: {
                    return "%M";
                }
                case DAY: {
                    return "%D";
                }
                case HOUR: {
                    return "%H";
                }
            }
            throw new Error("Unsupported : " + String.valueOf((Object)this));
        }

        public String patternPattern() {
            switch (this) {
                case YEAR: {
                    return "%Y";
                }
                case MONTH: {
                    return "%[_0]?M";
                }
                case DAY: {
                    return "%[_0]?D";
                }
                case HOUR: {
                    return "%[_0]?H";
                }
            }
            throw new Error("Unsupported : " + String.valueOf((Object)this));
        }
    }
}

