/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exceptions;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.ExceptionWithDebuggingHint;
import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.IOException;

public class ProcessDiedException
extends IOException
implements ExceptionWithLogTail,
ExceptionWithDebuggingHint,
ICodedException {
    private static final long serialVersionUID = 1L;
    private SmartLogTail logTail;
    private ExceptionWithDebuggingHint.DebuggingHint debuggingHint;
    private InfoMessage.MessageCode code;
    private int exitCode;

    public ProcessDiedException(String message, SmartLogTail logTail, ExceptionWithDebuggingHint.DebuggingHint debuggingHint, int exitCode) {
        super(message);
        this.logTail = logTail;
        this.debuggingHint = debuggingHint;
        this.exitCode = exitCode;
    }

    public ProcessDiedException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public ExceptionWithDebuggingHint.DebuggingHint getDebuggingHint() {
        return this.debuggingHint;
    }

    @Override
    public SmartLogTail getLogTail() {
        return this.logTail;
    }

    @Override
    public InfoMessage.MessageCode getCode() {
        return this.code;
    }

    public ProcessDiedException withCode(InfoMessage.MessageCode code) {
        this.code = code;
        return this;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static ProcessDiedException getExceptionOnProcessDeath(String description, Throwable origException, ExceptionWithDebuggingHint.DebuggingHint debuggingHint, boolean manuallyAborted, Integer processReturnCode, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        if (processReturnCode != null) {
            SmartLogTail tail = null;
            if (smartLogTailBuilder != null) {
                tail = smartLogTailBuilder.get();
            }
            if (manuallyAborted) {
                return new ProcessDiedException(description + " - manually aborted", null, null, processReturnCode);
            }
            if (processReturnCode == 137) {
                return new ProcessDiedException(description + " (exit code: " + processReturnCode + ", killed - maybe out of memory ?)", tail, debuggingHint, processReturnCode);
            }
            if (processReturnCode == 0) {
                return new ProcessDiedException(description + " - without error code", tail, debuggingHint, processReturnCode);
            }
            return new ProcessDiedException(description + " (exit code: " + processReturnCode + ")", tail, debuggingHint, processReturnCode);
        }
        return new ProcessDiedException(description + " seems to have died", origException);
    }
}

