/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.exceptions.DKUSecurityException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ExceptionUtils {
    public static final String UNKNOWN_AUTH_CTX_IDENTIFIER = "Unknown AuthCtx identifier: ";
    public static final String FAILED_TO_CREATE_AN_AUTH_CTX_FROM_IDENTIFIER = "Failed to create an AuthCtx from identifier: ";

    public static String getStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        t.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static String formatMessage(Throwable t) {
        return String.valueOf(t.getClass()) + ": " + t.getMessage();
    }

    public static String getMessageWithCauses(Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (t.getMessage() == null) {
            sb.append(t.getClass().getSimpleName());
        } else if (t instanceof NumberFormatException || t instanceof OutOfMemoryError) {
            sb.append(t.getClass().getSimpleName()).append(": ");
        } else if (t instanceof ClassNotFoundException) {
            sb.append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        } else if (t instanceof DKUSecurityException && t.getMessage().startsWith(UNKNOWN_AUTH_CTX_IDENTIFIER)) {
            sb.append("User does not exist on node");
        } else if (t instanceof DKUSecurityException && t.getMessage().startsWith(FAILED_TO_CREATE_AN_AUTH_CTX_FROM_IDENTIFIER)) {
            sb.append("Error when retrieving user details on node");
        } else {
            sb.append(t.getMessage());
        }
        t = t.getCause();
        ExceptionUtils.addThrowableAndAllItsCausesToStringBuilderAsCausedByMessages(sb, t);
        return sb.toString();
    }

    public static String appendCause(String message, Throwable t) {
        StringBuilder sb = new StringBuilder(message);
        ExceptionUtils.addThrowableAndAllItsCausesToStringBuilderAsCausedByMessages(sb, t);
        return sb.toString();
    }

    private static void addThrowableAndAllItsCausesToStringBuilderAsCausedByMessages(StringBuilder sb, Throwable t) {
        while (t != null) {
            String tmsg = null;
            try {
                tmsg = t.getMessage();
            }
            catch (AssertionError e) {
                tmsg = t.toString();
            }
            sb.append(", caused by: ").append(t.getClass().getSimpleName()).append(": ").append(tmsg);
            t = t.getCause();
        }
    }

    public static String getMessageWithCausesHTML(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span>");
        if (t.getMessage() == null) {
            sb.append("<span class=\"err-type\">").append(StringEscapeUtils.escapeHtml((String)t.getClass().getSimpleName())).append("</span>");
        } else {
            if (t instanceof NumberFormatException || t instanceof OutOfMemoryError) {
                sb.append("<span class=\"err-type\">").append(StringEscapeUtils.escapeHtml((String)t.getClass().getSimpleName())).append(": </span>");
            }
            sb.append("<span class=\"err-msg\">");
            if (t instanceof DKUSecurityException && t.getMessage().startsWith(UNKNOWN_AUTH_CTX_IDENTIFIER)) {
                sb.append("User does not exist on node. ");
            } else if (t instanceof DKUSecurityException && t.getMessage().startsWith(FAILED_TO_CREATE_AN_AUTH_CTX_FROM_IDENTIFIER)) {
                sb.append("Error when retrieving user details on node. ");
            }
            sb.append(StringEscapeUtils.escapeHtml((String)t.getMessage())).append("</span>");
        }
        t = t.getCause();
        ExceptionUtils.addThrowableAndAllItsCausesToStringBuilderAsCausedByMessagesHTML(sb, t);
        sb.append("</span>");
        return sb.toString();
    }

    public static String appendCauseHTML(String htmlMessage, Throwable t) {
        if (htmlMessage.endsWith("</span></span>")) {
            htmlMessage = htmlMessage.substring(0, htmlMessage.length() - 8);
        }
        StringBuilder sb = new StringBuilder(htmlMessage);
        ExceptionUtils.addThrowableAndAllItsCausesToStringBuilderAsCausedByMessagesHTML(sb, t);
        sb.append("</span>");
        return sb.toString();
    }

    private static void addThrowableAndAllItsCausesToStringBuilderAsCausedByMessagesHTML(StringBuilder sb, Throwable t) {
        while (t != null) {
            String tmsg = null;
            try {
                tmsg = t.getMessage();
            }
            catch (AssertionError e) {
                tmsg = t.toString();
            }
            sb.append("<span class=\"err-cause\"><span class=\"err-type\">, caused by: ").append(StringEscapeUtils.escapeHtml((String)t.getClass().getSimpleName())).append(":</span>&nbsp;<span class=\"err-msg\">").append(StringEscapeUtils.escapeHtml((String)tmsg)).append("</span></span>");
            t = t.getCause();
        }
    }

    public static String getMessageWithSQLNest(SQLException t) {
        StringBuilder sb = new StringBuilder();
        if (t.getMessage() == null) {
            sb.append(t.getClass().getSimpleName());
        } else {
            sb.append(t.getMessage());
        }
        for (t = t.getNextException(); t != null; t = t.getNextException()) {
            sb.append(", caused by: ").append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        }
        return sb.toString();
    }

    public static SQLException newSQLExceptionWithNestedMessages(SQLException e) {
        if (e.getNextException() == null) {
            return e;
        }
        return new SQLException(ExceptionUtils.getMessageWithSQLNest(e));
    }

    public static boolean hasCauseWithMessage(Throwable e, String needle) {
        String lowerNeedle = needle.toLowerCase(Locale.ENGLISH);
        do {
            String msg;
            if ((msg = e.getMessage()) == null || !msg.toLowerCase(Locale.ENGLISH).contains(lowerNeedle)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    public static boolean hasCauseWithMessageRe(Throwable e, String regexp) {
        Pattern p = Pattern.compile(regexp, 2);
        while (e != null) {
            if (!StringUtils.isEmpty((String)e.getMessage()) && p.matcher(e.getMessage()).find()) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    public static boolean hasCauseOfClass(Throwable e, String clazzName) {
        do {
            if (!e.getClass().getName().equals(clazzName)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    public static boolean hasCauseOfClass(Throwable e, Class<?> classOf) {
        do {
            if (!e.getClass().getName().equals(classOf.getName())) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    private ExceptionUtils() {
    }

    public static <T, R, E extends Exception> Function<T, R> checkedFunction(ThrowingFunction<T, R, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, E extends Exception> Predicate<T> checkedPredicate(ThrowingPredicate<T, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> checkedConsumer(ThrowingConsumer<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingPredicate<T, E extends Exception> {
        public boolean apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, E extends Exception> {
        public R get() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

