/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dss.shadelib.com.google.gson.internal.UnsafeAllocator;
import java.lang.reflect.Modifier;
import org.springframework.util.ReflectionUtils;

public class ObjectUtils {
    private static final UnsafeAllocator UNSAFE_ALLOCATOR = UnsafeAllocator.INSTANCE;

    public static <T> T shallowCopy(T src) {
        try {
            Class<?> c = src.getClass();
            Object ret = UNSAFE_ALLOCATOR.newInstance(c);
            ReflectionUtils.doWithFields(c, f -> {
                if (Modifier.isStatic(f.getModifiers())) {
                    return;
                }
                f.setAccessible(true);
                f.set(ret, f.get(src));
            });
            return (T)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + src.getClass().getCanonicalName() + ". Does it have a default constructor ?");
        }
    }
}

