/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Params {
    private static final DKULogger logger = DKULogger.getLogger(Params.class);
    KeyValue rootKV = new KeyValue();
    protected Map<String, String> params = new HashMap<String, String>();
    private Map<String, KeyValue> intermediate = new HashMap<String, KeyValue>();

    public Params() {
    }

    public Params(Map<String, String> input) {
        for (Map.Entry<String, String> ie : input.entrySet()) {
            this.add(ie.getKey(), ie.getValue());
        }
    }

    public Map<String, String> getAll() {
        return ImmutableMap.copyOf(this.params);
    }

    private void addRec(KeyValue prevKV, String[] chunks, int curIdx, String value, String curPrefix) {
        String curChunk = chunks[curIdx];
        if (!((String)curPrefix).isEmpty()) {
            curPrefix = (String)curPrefix + ".";
        }
        curPrefix = (String)curPrefix + curChunk;
        KeyValue kv = prevKV.getChild(curChunk);
        if (kv == null) {
            kv = new KeyValue(curChunk);
            this.intermediate.put((String)curPrefix, kv);
            prevKV.children.add(kv);
        }
        if (curIdx + 1 == chunks.length) {
            kv.setValue(value);
            this.params.put((String)curPrefix, value);
        } else {
            this.addRec(kv, chunks, curIdx + 1, value, (String)curPrefix);
        }
    }

    public void add(String key, String value) {
        String[] chunks = key.split("\\.");
        this.addRec(this.rootKV, chunks, 0, value, "");
    }

    public void add(String key, long value) {
        this.add(key, Long.toString(value));
    }

    public void add(String key, double value) {
        this.add(key, Double.toString(value));
    }

    public Params with(String key, String value) {
        this.add(key, value);
        return this;
    }

    public Params with(String key, long value) {
        this.add(key, value);
        return this;
    }

    public Params with(String key, double value) {
        this.add(key, value);
        return this;
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public String getParam(String name, String defaultValue) {
        return this.getParam(name, defaultValue, false);
    }

    public String getParam(String name, String defaultValue, boolean translateEmptyToNull) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        if (translateEmptyToNull && s.isEmpty()) {
            return defaultValue;
        }
        return s;
    }

    public String getParamOrEmpty(String name) {
        return this.getParam(name, "");
    }

    public String getMandParam(String name) {
        String s = this.params.get(name);
        if (s == null) {
            throw ErrorContext.iae("Missing param '" + name + "'");
        }
        return s;
    }

    public String getNonEmptyMandParam(String name) {
        String s = this.getMandParam(name);
        if (s.isEmpty()) {
            throw ErrorContext.iae("Empty param '" + name + "'");
        }
        return s;
    }

    public boolean getBoolParam(String name, boolean defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return s.equalsIgnoreCase("true") || s.startsWith("y") || s.startsWith("Y");
    }

    public int getIntParamOrElse(String name, int defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            logger.warnV(e, "Invalid number format: %s when trying to read %s param, using default value: %s.", s, name, defaultValue);
            return defaultValue;
        }
    }

    public int getIntParam(String name, Integer defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public int getIntParam(String name) {
        String s = this.getMandParam(name);
        return Integer.parseInt(s);
    }

    public short getShortParam(String name, Short defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return Short.parseShort(s);
    }

    public short getShortParam(String name) {
        String s = this.getMandParam(name);
        return Short.parseShort(s);
    }

    public int getUShortParam(String name, Integer defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        int res = Integer.parseInt(s);
        if (!this.ushortBoundsCheck(res)) {
            throw new NumberFormatException(s + " is not an unsigned short.");
        }
        return res;
    }

    public int getUShortParam(String name) {
        return this.getUShortParam(name, null);
    }

    private boolean ushortBoundsCheck(int i) {
        return i >= 0 && i <= 65535;
    }

    public long getLongParam(String name, long defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return Long.parseLong(s);
    }

    public long getLongParam(String name) {
        String s = this.getMandParam(name);
        return Long.parseLong(s);
    }

    public double getDoubleParam(String name, double defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return Double.parseDouble(s);
    }

    public double getDoubleParam(String name) {
        String s = this.getMandParam(name);
        return Double.parseDouble(s);
    }

    public float getFloatParam(String name, float defaultValue) {
        String s = this.params.get(name);
        if (s == null) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public float getFloatParam(String name) {
        String s = this.getMandParam(name);
        return Float.parseFloat(s);
    }

    public char getCharParam(String name) {
        this.getMandParam(name);
        return this.getCharParam(name, null);
    }

    public char getCharParam(String name, Character defaultValue) {
        String s = this.getParam(name, "" + defaultValue);
        if (s.length() != 1) {
            if (s.startsWith("\\u")) {
                try {
                    int code = Integer.parseInt(s.substring(2), 16);
                    return (char)code;
                }
                catch (Exception e) {
                    throw Params.exceptSingleChar(name);
                }
            }
            if (s.startsWith("u") && s.length() == 5) {
                try {
                    int code = Integer.parseInt(s.substring(1), 16);
                    return (char)code;
                }
                catch (Exception e) {
                    throw Params.exceptSingleChar(name);
                }
            }
            throw Params.exceptSingleChar(name);
        }
        return s.charAt(0);
    }

    private static IllegalArgumentException exceptSingleChar(String param) {
        return ErrorContext.iae("Expected single char in param '" + param + "'");
    }

    public List<String> getCSVParamAsList(String name, String defaultValue, String separator) {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(Arrays.asList(this.getCSVParam(name, defaultValue, separator)));
        return out;
    }

    public static List<String> getFromCSVList(String value, String defaultValue, String separator) {
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (value == null) {
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])value.split(separator));
    }

    public static List<Integer> getFromCSVIntList(String value, String defaultValue, String separator) {
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (value == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String x : value.split(separator)) {
            out.add(Integer.parseInt(x));
        }
        return out;
    }

    public List<String> getCSVParamAsList(String name, String defaultValue) {
        return this.getCSVParamAsList(name, defaultValue, ",");
    }

    public List<String> getCSVParamAsList(String name) {
        return this.getCSVParamAsList(name, null);
    }

    public String[] getCSVParam(String name, String defaultValue) {
        return this.getCSVParam(name, defaultValue, ",");
    }

    public String[] getCSVParam(String name, String defaultValue, String separator) {
        String v = this.getParam(name, defaultValue);
        if (v == null) {
            return new String[0];
        }
        return v.split(separator);
    }

    public String[] getCSVParam(String name) {
        return this.getCSVParam(name, null);
    }

    public List<Integer> getCSVParamAsIntList(String name, String defaultValue) {
        String v = this.getParam(name, defaultValue);
        String[] chunks = v.split(",");
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : chunks) {
            if (s.isEmpty()) continue;
            out.add(Integer.parseInt(s));
        }
        return out;
    }

    public KeyValue getAsKV(String name) {
        return this.intermediate.get(name);
    }

    public String get(String prefix, String suffix) {
        return this.getParam(prefix + "." + suffix);
    }

    public List<String> getChildrenAsIntList(String prefix) {
        KeyValue child;
        KeyValue kv = this.intermediate.get(prefix);
        if (kv == null) {
            return null;
        }
        ArrayList<String> validList = new ArrayList<String>();
        int i = 0;
        while ((child = kv.getChild("" + i)) != null) {
            validList.add("" + i);
            ++i;
        }
        for (KeyValue child2 : kv.getChildren()) {
            String childKey = child2.key;
            if (validList.contains(childKey)) continue;
            throw new IllegalArgumentException("In prefix " + prefix + ", key " + childKey + " does not follow a valid list");
        }
        Collections.sort(validList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = Integer.parseInt(o1);
                int i2 = Integer.parseInt(o2);
                return Integer.compare(i1, i2);
            }
        });
        return validList;
    }

    public List<String> childrenFullNames(String prefix) {
        KeyValue kv = this.intermediate.get(prefix);
        if (kv == null) {
            return null;
        }
        ArrayList<String> o = new ArrayList<String>();
        for (KeyValue child : kv.getChildren()) {
            o.add(prefix + "." + child.key());
        }
        return o;
    }

    public static char getAsChar(String s) {
        if (s.length() != 1) {
            if (s.startsWith("\\u")) {
                try {
                    int code = Integer.parseInt(s.substring(2), 16);
                    return (char)code;
                }
                catch (Exception e) {
                    throw ErrorContext.iaef("Expect a single char but got '%s'", s, new Object[0]);
                }
            }
            if (s.startsWith("u") && s.length() == 5) {
                try {
                    int code = Integer.parseInt(s.substring(1), 16);
                    return (char)code;
                }
                catch (Exception e) {
                    throw ErrorContext.iaef("Expect a single char but got '%s'", s, new Object[0]);
                }
            }
            if (s.equals("\\t")) {
                return '\t';
            }
            throw ErrorContext.iaef("Expect a single char but got '%s'", s, new Object[0]);
        }
        return s.charAt(0);
    }

    public static class KeyValue {
        private String key;
        private String value;
        private List<KeyValue> children;

        public KeyValue() {
        }

        public KeyValue(String key) {
            this.key = key;
        }

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return "[KV k=" + this.key + " v=" + this.value + " children=" + this.getChildren().size() + "]";
        }

        public KeyValue getChild(String childKey) {
            for (KeyValue kv : this.getChildren()) {
                if (!kv.key().equals(childKey)) continue;
                return kv;
            }
            return null;
        }

        public List<KeyValue> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<KeyValue>();
            }
            return this.children;
        }

        public List<String> childrenKeys(String prefix, boolean includeSelfKey) {
            ArrayList<String> o = new ArrayList<String>();
            for (KeyValue child : this.getChildren()) {
                Object name = child.key;
                if (includeSelfKey) {
                    name = this.key + "." + (String)name;
                }
                if (prefix != null) {
                    name = prefix + "." + (String)name;
                }
                o.add((String)name);
            }
            return o;
        }
    }
}

