/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.kernel.protocol.v5.kernel;

import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.Timeout;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.toree.communication.ZMQMessage;
import org.apache.toree.kernel.protocol.v5.Header;
import org.apache.toree.kernel.protocol.v5.Header$;
import org.apache.toree.kernel.protocol.v5.KMBuilder;
import org.apache.toree.kernel.protocol.v5.KMBuilder$;
import org.apache.toree.kernel.protocol.v5.KernelMessage;
import org.apache.toree.kernel.protocol.v5.package$;
import org.apache.toree.utils.LogLike;
import org.slf4j.Logger;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;

public final class Utilities$
implements LogLike {
    public static Utilities$ MODULE$;
    private final Timeout timeout;
    private final String loggerName;
    private final Logger logger;

    static {
        new Utilities$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void org$apache$toree$utils$LogLike$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$toree$utils$LogLike$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public String ByteStringToString(ByteString byteString) {
        return new String((byte[])byteString.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8"));
    }

    public ByteString StringToByteString(String string2) {
        return ByteString$.MODULE$.apply(string2.getBytes());
    }

    public KernelMessage ZMQMessageToKernelMessage(ZMQMessage message) {
        int delimiterIndex = message.frames().indexOf((Object)ByteString$.MODULE$.apply("<IDS|MSG>".getBytes()));
        Seq ids = (Seq)((TraversableLike)message.frames().take(delimiterIndex)).map((Function1 & Serializable & scala.Serializable)byteString -> (byte[])byteString.toArray(ClassTag$.MODULE$.Byte()), Seq$.MODULE$.canBuildFrom());
        Header header = Json$.MODULE$.parse(this.ByteStringToString((ByteString)message.frames().apply(delimiterIndex + 2))).as(Header$.MODULE$.headerReads());
        Header parentHeader = (Header)this.parseAndHandle(this.ByteStringToString((ByteString)message.frames().apply(delimiterIndex + 3)), package$.MODULE$.ParentHeader().headerReads(), (Function1 & Serializable & scala.Serializable)valid -> valid, (Function1 & Serializable & scala.Serializable)x$1 -> null);
        Map<String, JsValue> metadata = Json$.MODULE$.parse(this.ByteStringToString((ByteString)message.frames().apply(delimiterIndex + 4))).as(Reads$.MODULE$.mapReads(Reads$.MODULE$.JsValueReads()));
        return new KMBuilder(KMBuilder$.MODULE$.apply$default$1()).withIds((Seq<byte[]>)ids.toList()).withSignature(this.ByteStringToString(message.frame(delimiterIndex + 1))).withHeader(header).withParentHeader(parentHeader).withMetadata(metadata).withContentString(this.ByteStringToString(message.frame(delimiterIndex + 5))).build(false);
    }

    public ZMQMessage KernelMessageToZMQMessage(KernelMessage kernelMessage) {
        ListBuffer frames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        kernelMessage.ids().map((Function1 & Serializable & scala.Serializable)id2 -> frames.$plus$eq((Object)ByteString$.MODULE$.apply((byte[])id2)), Seq$.MODULE$.canBuildFrom());
        frames.$plus$eq((Object)this.StringToByteString("<IDS|MSG>"));
        frames.$plus$eq((Object)this.StringToByteString(kernelMessage.signature()));
        frames.$plus$eq((Object)this.StringToByteString(Json$.MODULE$.toJson(kernelMessage.header(), Header$.MODULE$.headerWriters()).toString()));
        frames.$plus$eq((Object)this.StringToByteString(Json$.MODULE$.toJson(kernelMessage.parentHeader(), Header$.MODULE$.headerWriters()).toString()));
        frames.$plus$eq((Object)this.StringToByteString(Json$.MODULE$.toJson(kernelMessage.metadata(), Writes$.MODULE$.mapWrites(Writes$.MODULE$.JsValueWrites())).toString()));
        frames.$plus$eq((Object)this.StringToByteString(kernelMessage.contentString()));
        return new ZMQMessage((Seq<ByteString>)frames);
    }

    public <T, U> U parseAndHandle(String json, Reads<T> reads, Function1<T, U> handler) {
        return this.parseAndHandle(json, reads, handler, (Function1 & Serializable & scala.Serializable)invalid -> {
            MODULE$.logger().error(new StringBuilder(22).append("Could not parse JSON, ").append(json).toString());
            throw new Throwable(new StringBuilder(22).append("Could not parse JSON, ").append(json).toString());
        });
    }

    public <T, U> U parseAndHandle(String json, Reads<T> reads, Function1<T, U> handler, Function1<Seq<Tuple2<JsPath, Seq<JsonValidationError>>>, U> errHandler) {
        return Json$.MODULE$.parse(json).validate(reads).fold(errHandler, (Function1 & Serializable & scala.Serializable)content -> handler.apply(content));
    }

    private Utilities$() {
        MODULE$ = this;
        LogLike.$init$(this);
        this.timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(21474835)).seconds());
    }
}

