import os, json
from dataiku.code_studio import CodeStudioTemplate

class MyCodeStudio(CodeStudioTemplate):
    def __init__(self, config, plugin_config):
        """
        :param config: the dict of the configuration of the object
        :param plugin_config: contains the plugin settings
        """
        self.config = config
        self.plugin_config = plugin_config
        
    def build_spec(self, env):
        """
        Compute the spec (for mode=SPEC_COMPUTER)
        
        :param env: the build env

        :returns: the spec, ie a dict with a field 'dockerfile'
        """
        return {"dockerfile": "# this is an empty dockerfile"}

    def build_launch(self, env):
        """
        Compute the spec (for mode=SPEC_COMPUTER)
        
        :param env: the launch env

        :returns: the spec, as a dict
        """
        return {}
        
    def build_block_list(self, build_env, launch_env):
        """
        Compute the spec (for mode=BLOCK_LIST_PROVIDER)
        
        :param build_env: the build env (None if computing the launch spec)
        :param launch_env: the launch env (None if computing the build spec)

        :returns: a list of CodeStudio blocks defining the template
        """
        blocks_json = """
__TEMPLATE_BLOCKS__
"""
        # refer to the right location for the resources
        resource_folder = os.environ['DKU_CUSTOM_RESOURCE_FOLDER']
        blocks_json = blocks_json.replace("__DKU_CUSTOM_RESOURCE_FOLDER__", resource_folder)
        # parse it
        blocks_list = json.loads(blocks_json)
        return {"blocks": blocks_list}
