(function() {
    "use strict";

    const addDatasetFirstMenu = {
        bindings: {
            flowScope: '=',
            datasetsMenus : '=',
            pinnedItems: '=',
            flowOthersItems: '=',
            recipesMenus: '=',
            onNextStep: '&',
            hideOtherSection: '<'
        },
        templateUrl: 'static/dataiku/add-dataset-workflow/add-dataset-first-menu/add-dataset-first-menu.html',
        controller: function($state, $stateParams, translate, AddDatasetWorkflowService, $timeout, $window) {
            const ctrl = this;

            ctrl.$onInit = function() {
                $timeout(ctrl.calculatePinMenuMaxHeight)
                angular.element($window).on('resize', ctrl.calculatePinMenuMaxHeight);
            }

            ctrl.$onDestroy = function() {
                angular.element($window).off('resize', ctrl.calculatePinMenuMaxHeight);
            }

            ctrl.showUploadFile = function() {
                return ctrl.datasetsMenus.find(item => item.type === 'UploadedFiles') !== undefined
            }

            ctrl.calculatePinMenuMaxHeight = function() {
                const pinnedList = document.getElementsByClassName('pinned-items-list')[0];
                if (!pinnedList) {
                    return;
                }
                const pinnedListPos = pinnedList.getBoundingClientRect();
                const subT = pinnedListPos.top;
                const vH = $window.innerHeight;

                const bottomMargin = 24;
                const maxHeight = vH - subT - bottomMargin;
                pinnedList.style.setProperty('--pin-menu-max-height', `${maxHeight}px`);
            }

            ctrl.moveToNextStep = function() {
                ctrl.onNextStep();
            }

            ctrl.newFlowZone = function() {
                ctrl.flowScope.moveToFlowZone([], true, [])
            }

            ctrl.goToDataCatalog = function() {
                $state.go('projects.project.datacatalog.home', { zoneId: ctrl.flowScope.getRelevantZoneId($stateParams.zoneId) })
            }

            ctrl.getRelevantZoneId = function() {
                ctrl.relevantZoneId = ctrl.flowScope.getRelevantZoneId($stateParams.zoneId);
                return ctrl.relevantZoneId
            }

            ctrl.showCERestrictionModal = function(label) {
                ctrl.flowScope.showCERestrictionModal(label);
            }

            ctrl.togglePin = function(event, item) {
                event.stopPropagation();
                AddDatasetWorkflowService.togglePinItem(item.type, ctrl.flowScope);
            }

        }
    }


    angular.module("dataiku.addDatasetWorkflow").component("addDatasetFirstMenu", addDatasetFirstMenu);
})();