(function() {
    'use strict';

    const app = angular.module('dataiku.constants');

    // ChartFilter.FilterType.java
    const FILTER_TYPES = {
        ALPHANUM_FACET: 'ALPHANUM_FACET',
        NUMERICAL_FACET: 'NUMERICAL_FACET',
        DATE_FACET: 'DATE_FACET'
    };

    // ChartFilter.FilterSelectionType.java
    const FILTER_SELECTION_TYPES = {
        RANGE_OF_VALUES: 'RANGE_OF_VALUES',
        SINGLE_SELECT: 'SINGLE_SELECT',
        MULTI_SELECT: 'MULTI_SELECT'
    };

    // AxisDef.type.java
    const COLUMN_TYPES = {
        ALPHANUM: 'ALPHANUM',
        NUMERICAL: 'NUMERICAL',
        DATE: 'DATE'
    };

    // ChartFilter.DateFilterPart.java
    const DATE_PARTS = {
        YEAR: 'YEAR',
        QUARTER_OF_YEAR: 'QUARTER_OF_YEAR',
        WEEK_OF_YEAR: 'WEEK_OF_YEAR',
        MONTH_OF_YEAR: 'MONTH_OF_YEAR',
        DAY_OF_MONTH: 'DAY_OF_MONTH',
        DAY_OF_WEEK: 'DAY_OF_WEEK',
        HOUR_OF_DAY: 'HOUR_OF_DAY'
    };

    // ChartFilter.DateFilterType.java
    const DATE_TYPES = {
        RANGE : 'RANGE',
        RELATIVE: 'RELATIVE',
        PART: 'PART'
    };

    const DAYS_OF_WEEK_LABELS = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];

    app.constant('CHART_FILTERS', {
        FILTER_TYPES,
        FILTER_SELECTION_TYPES,
        COLUMN_TYPES,
        DATE_PARTS,
        DATE_TYPES,
        DAYS_OF_WEEK_LABELS
    });

})();
