(function() {
    'use strict';
    const app = angular.module('dataiku.recipes');

    app.controller("ListAccessRecipeCreationController", function($scope, $controller, $stateParams, DataikuAPI, RecipeComputablesService) {

        $scope.recipeType = "list_access";
        $scope.inputFolderOnly = true;

        $controller("SingleOutputDatasetRecipeCreationController", { $scope: $scope });

        $scope.autosetName = async function() {
            if ($scope.recipe?.inputs?.main?.items?.[0]?.description) {
                const niceInputName = (await DataikuAPI.shakers.convertToASCII([$scope.recipe.inputs.main.items[0].description], true, true)).data[0];
                $scope.maybeSetNewDatasetName(niceInputName + "_access");
            }
        };

        $scope.recipeName = {};
        $scope.recipe = {
            type: 'list_access',
            projectKey: $stateParams.projectKey,
            inputs: {
                main: {
                    items: []
                },
                manualMapping: {
                    items: []
                }
            },
            outputs: {
                main: {
                    items: []
                }
            }
        };

        $scope.$watchCollection('recipe.inputs.main.items', function(inputs) {
            if (inputs?.length) {
                const folderId = inputs[0].ref;
                $scope.io.inputFolder = { smartName: folderId, name: $scope.computablesMap?.[folderId]?.label };

                DataikuAPI.flow.zones.getZoneId($stateParams.projectKey, {
                    id: folderId,
                    type: "MANAGED_FOLDER",
                    projectKey: $stateParams.projectKey
                }).success(function(zone) {
                    $scope.zone = zone.id;
                }).error(setErrorInScope.bind($scope));
            }
        })

        RecipeComputablesService.getComputablesMap($scope.recipe, $scope).then(function(map) {
            $scope.setComputablesMap(map);
        });

    });

    app.controller("ListAccessRecipeController", function($controller, $scope, $q, PartitionDeps, ComputableSchemaRecipeSave, SmartId, DataikuAPI) {

        $controller("_RecipeWithEngineBehavior", {$scope:$scope});

        $scope.hooks.save = function() {
            const deferred = $q.defer();
            const recipeSerialized = angular.copy($scope.recipe);
            PartitionDeps.prepareRecipeForSerialize(recipeSerialized);
            ComputableSchemaRecipeSave.handleSave($scope, recipeSerialized, "", deferred);
            return deferred.promise;
        };

        $scope.hooks.preRunValidate = function() {
            const deferred = $q.defer();
            deferred.resolve({ "ok": true });
            return deferred.promise;
        };

        $scope.enableAutoFixup();

        $scope.hooks.onRecipeLoaded = function() {
            $scope.hooks.updateRecipeStatus();
        };

        $scope.hooks.updateRecipeStatus = function() {
            const deferred = $q.defer();
            $scope.updateRecipeStatusBase(false).then(function() {
                // $scope.recipeStatus should have been set by updateRecipeStatusBase
                if (!$scope.recipeStatus) return deferred.reject();
                deferred.resolve($scope.recipeStatus);
            });
            return deferred.promise;
        };

        $scope.$watch('recipe.inputs.manualMapping.items', function(nv, ov) {
            if (!nv) return;

            $scope.manualMappingDataset = nv.length ? nv[0].ref : undefined;
            if (!$scope.manualMappingDataset) {
                $scope.manualMappingDatasetColumns = [];
                return;
            }

            const resolvedRef = SmartId.resolve($scope.manualMappingDataset, $scope.recipe.projectKey);
            DataikuAPI.datasets.get(resolvedRef.projectKey, resolvedRef.id, $scope.recipe.projectKey).then(response => {
                const schema = response.data.schema;
                $scope.manualMappingDatasetColumns = schema.columns.map(col => col.name)

                if (!ov || ov.length !== 1 || nv[0].ref !== ov[0].ref) {
                    $scope.recipe.params.manualMappingDssGroupCol = undefined;
                    $scope.recipe.params.manualMappingEntraGroupCol = undefined;
                }
            });
        }, true);

        // This is needed only once after the computablesMap have been injected
        $scope.$watch('computablesMap', function(nv, ov) {
            if (nv == null || ov != null) {
                return;
            }
            const outputName = $scope.recipe?.outputs?.main?.items?.[0]?.ref;
            if (outputName != null && $scope.computablesMap?.[outputName]) {
                $scope.computablesMap[outputName].usableAsInput.manualMapping.usable = false;
                $scope.computablesMap[outputName].usableAsInput.manualMapping.reason = "The output of this recipe cannot be used as an input for itself";

            }
        }, true);

        $scope.$watch("recipe.params", $scope.updateRecipeStatusLater, true);
    });

})();
