/* eslint-disable no-console */
/* global _wt1Q */
window.dkuUsageReportingUtils = function() {
    'use strict';

    function isDefined(value) {return typeof value !== 'undefined';}
    function isUndefined(value) { return !isDefined(value); }

    /* Do not change. Keep in sync with utils.js */
    const dkuHashCode = function(str){
        var hash = 0, i, char, l;
        if (str.length == 0) return hash;
        for (i = 0, l = str.length; i < l; i++) {
            char  = str.charCodeAt(i);
            hash  = ((hash<<5)-hash)+char;
            hash |= 0; // Convert to 32bit integer
        }
        return hash;
    };

    function eventIsEnabledInOpenOnlyMode(_type) {
                return ["studio-open", "v3-report",
                        "nps-survey", "nps-survey-decline",
                        "action-triggered-survey", "action-triggered-survey-decline"].includes(_type);
            }

    let standaloneModeAppConfig;
    let standaloneModeMode;
    let standaloneModeConfigured;
    let standaloneModeEventsBeforeConfiguration = [];

    // DSS Load identifier
    const DL_ID = (Math.random().toString(36)+'00000000000000000').slice(2, 12);

    const ret = {

        /**
         * Needs _wt1Q to already be setup
         */
        _configure: function(appConfig) {
            if (isDefined(appConfig.dipInstanceId)) {
                _wt1Q.push(["setVisitorParam", "dipInstanceId", appConfig.dipInstanceId]);
            }
            if (isDefined(appConfig.installId)) {
                _wt1Q.push(["setVisitorParam", "installId", appConfig.installId]);
            }
            if (appConfig.licenseKind) {
                _wt1Q.push(["setVisitorParam", "dssLicenseKind", appConfig.licenseKind]);
            } else {
                console.warn("No license kind in", appConfig);
            }
            if (appConfig.distrib) {
                _wt1Q.push(["setVisitorParam", "bkdDistrib", appConfig.distrib]);
                _wt1Q.push(["setVisitorParam", "bkdDistribVersion", appConfig.distribVersion]);
            }
            if (appConfig.registrationChannel) {
                _wt1Q.push(["setVisitorParam", "regChannel", appConfig.registrationChannel]);
            }
            if (appConfig.deploymentMode) {
                _wt1Q.push(["setVisitorParam", "deploymentMode", appConfig.deploymentMode]);
            }
            if (appConfig.dkuCloudSpaceId) {
                // spaceId is used by analytics team, do not rename
                _wt1Q.push(["setVisitorParam", "spaceId", appConfig.dkuCloudSpaceId]);
            }
            if (appConfig.nodeType) {
                _wt1Q.push(["setVisitorParam", "nodeType", appConfig.nodeType]);
            }
            if (appConfig.featureFlags !== null) {
                _wt1Q.push(["setVisitorParam", "enabledFeatureFlags", appConfig.featureFlags.join(",")]);   
            }
            _wt1Q.push(["setVisitorParam", "isAutomation", appConfig.isAutomation]);
            _wt1Q.push(["setVisitorParam", "dssVersion", appConfig.version && appConfig.version.product_version ? appConfig.version.product_version : "unknown"]);
            if (appConfig.login) {
                _wt1Q.push(["setSessionParam", "dssUser", dkuHashCode(appConfig.login)]);
                _wt1Q.push(["setVisitorParam", "vdssUser", dkuHashCode(appConfig.login)]);
            }
        },

        /**
         * Add login, email to event payload and profile according to privacy rules 
         */
        _addUserPropertiesToEventPayload: function(appConfig, params) {
            if (appConfig) {
                if (appConfig.login) {
                    params.edssUser = dkuHashCode(appConfig.login);
                    params.loginh = md5(appConfig.login.toLowerCase());
                    if (appConfig.udrPrivacyMode == "DEFAULT") {
                        params.login = appConfig.login;
                    }
                }
                if (appConfig.user && appConfig.user.email && appConfig.user.email != "") {
                    params.emailh = md5(appConfig.user.email.toLowerCase());
                    if (appConfig.udrPrivacyMode == "DEFAULT") {
                        params.email = appConfig.user.email;
                    }
                }
                if (appConfig.userProfile) {
                    params.userProfile = appConfig.userProfile.profile;
                }
                if (appConfig.userSettings) {
                    if (appConfig.userSettings.uiLanguage) {
                        params.userLanguage = appConfig.userSettings.uiLanguage;
                    }
                }
                if (appConfig.trialStatus) {
                    const trialStatus = appConfig.trialStatus;
                    if (trialStatus.expiresOn && trialStatus.expiresOn > 0) {
                        params.trialUserExpiration = trialStatus.expiresOn;
                    }
                    if (trialStatus.exists) {
                        if (trialStatus.valid) {
                            params.isTrialUser = true;
                        } else if (trialStatus.expired) {
                            params.isExpiredTrialUser = true;
                        } else if (trialStatus.illegal) {
                            params.isIllegalTrialUser = true;
                        }
                    }
                }
                if (window && window.navigator) {
                    if (window.navigator.language) {
                        params.browserLanguage = window.navigator.language;
                    }
                    if (window.navigator.languages) {
                        params.browserLanguages = window.navigator.languages.join(',');
                    }
                }
            }
        },

        _loadWT1JS: function() {
            (function() {
                    const script = document.createElement('script');
                    script.src = "/static/wt1/wt1.js";
                    script.type = 'text/javascript';
                    script.async = "true";
                    const script0 = document.getElementsByTagName("script")[0];
                    script0.parentNode.insertBefore(script, script0);
            })();
        },

        _trackEvent: function(appConfig, mode, type, params) {
            params.dlid = DL_ID;

            // When params contains object litterals, or class instances we
            // serialize them before sending them to the event queue.
            for (let key in params) {
                if (params.hasOwnProperty(key)) {
                    const value = params[key];

                    if (Object.prototype.toString.call(value) === '[object Object]') {
                        params[key] = JSON.stringify(value);
                    }
                }
            }

            if (window.devInstance) {
                const formattedDate = moment().format('HH:mm:ss.SSS');
                const prefix = '[' + formattedDate + ']';
                console.debug(prefix + " [" + mode + "] WT1: " + type, params); /*@console*/ // NOSONAR: OK to use console.
            }

            params.type = type;

            if (mode == 'NO') {
                return;
            } else if (mode == "OPEN_ONLY" && !eventIsEnabledInOpenOnlyMode(type)) {
                return;
            }

            _wt1Q.push(["trackEvent", params]);
        },

        /* Following functions are the public ones for standalone mode */

        standaloneModeBootstrap: async function() {
            window._wt1Q = [];

            const response = await fetch("/dip/api/get-configuration");
            standaloneModeAppConfig = await response.json();

            ret._configure(standaloneModeAppConfig);

            if (window.devInstance) {
                standaloneModeMode = 'NO';
            } else if (standaloneModeAppConfig.udrMode) {
                standaloneModeMode = standaloneModeAppConfig.udrMode;
            }
            standaloneModeConfigured = true;

            ret._loadWT1JS();

            for (const eventBeforeConfiguration of standaloneModeEventsBeforeConfiguration) {
                ret.standaloneModeTrackEvent(eventBeforeConfiguration.type, eventBeforeConfiguration.params);
            }
        },

        getAppConfig: function() {
            return standaloneModeAppConfig;
        },

        standaloneModeTrackEvent: function(type, params) {
            if (isUndefined(params)) {
                params = {};
            }

            if (!standaloneModeConfigured) {
                if (window.devInstance) {
                    console.debug("WT1-standalone: pre-configuration-event: " + type, params); /*@console*/ // NOSONAR: OK to use console.
                }
                // While it's not configured, we enqueue events, so that:
                // * the session and visitor params are set BEFORE we track the first state change event
                // * the proper privacy and minimal mode are taken into account
                standaloneModeEventsBeforeConfiguration.push({ "type": type, "params": params});
                return;
            }

            ret._addUserPropertiesToEventPayload(standaloneModeAppConfig, params, window);
            ret._trackEvent(standaloneModeAppConfig, standaloneModeMode, type, params);
        }
    }

    return ret;
}();
