(function () {
    "use strict";

    const inputFilterBlock = {
        bindings: {
            filter: '=',
            dataset: '=',
            schema: '=',
            recipeStatus: '=',
            onChange: '&',
            hideSqlFilter: '=',
            recipeVariables: '=',
            inputIndex: '<'
        },
        templateUrl: "/static/dataiku/nested-filters/input-filter-block/input-filter-block.component.html",
        controller: function inputFilterBlockController($scope, $element, $attrs, CreateModalFromTemplate, translate) {
            const ctrl = this;
            $scope.translate = translate;

            ctrl.$onInit = function () {            
                let defaults = {
                    filter: null,
                    dataset: null,
                    schema: null,
                    recipeStatus: null,
                    onChange: null,
                    hideSqlFilter: false,
                    recipeVariables: null,
                    inputIndex: null
                }
                $.each(defaults, function(param, value) {
                    if (param in ctrl) {
                        if (ctrl[param]===0) {
                            $scope[param] = ctrl[param]
                        } else {
                            $scope[param] = ctrl[param] || value;
                        }
                    } else {
                        $scope[param] = value;
                    }
                })
    
                $scope.showFilterModal = function() {
                    $scope.filter = $scope.filter || {};
                    let newScope = $scope.$new();
                    newScope.dataset = ctrl.dataset;
                    newScope.schema = ctrl.schema;
                    newScope.filter = $scope.filter;
                    newScope.recipeVariables = $scope.recipeVariables;
                    CreateModalFromTemplate('/static/dataiku/nested-filters/input-filter-block/filter-modal.component.html', newScope, null, function(newScope){
                        newScope.hideSqlFilter = $scope.hideSqlFilter || false;
                    });
                };
    
                $scope.ok = function() {
                    if ($scope.onChange) {
                        $scope.onChange();
                    }
                }
    
                $scope.$watch("filter", function(nv, ov) {
                    if (nv!==ov && ("virtualInputs" in $scope.$parent.params) && ($scope.$parent.params.virtualInputs.length>$scope.inputIndex)) {
                        $scope.$parent.params.virtualInputs[$scope.inputIndex].preFilter = $scope.filter;
                    }
                }, true);
            }

        },
    };

    angular.module("dataiku.nestedFilters").component("inputFilterBlock", inputFilterBlock);
})();
