import json
import sys

from dataiku.external_ml.proxy_model.common.inputformat import BaseWriter


class VertexAIDefaultWriter(BaseWriter):
    NAME = "INPUT_VERTEX_DEFAULT"

    def __init__(self, client):
        super(VertexAIDefaultWriter, self).__init__(client)

    def can_write(self, input_df):
        return self.write(input_df)

    def _build_instances(self, input_df):
        return [{key: str(value) for key, value in record.items()} for record in input_df.to_dict("records")]

    def compute_request_size(self, input_df):
        instances = self._build_instances(input_df)
        json_object = json.dumps(instances)
        return sys.getsizeof(json_object)

    def build_request_payload(self, input_df):
        params = {
            "instances": self._build_instances(input_df)
        }
        return params

    def write(self, input_df):
        return self.client.call_endpoint(self.build_request_payload(input_df), None).get("predictions")