/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.ClusterImplLoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Endpoints;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.EnvoyServerProtoData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class ClusterImplLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_impl_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterImplLoadBalancer(helper);
    }

    static final class ClusterImplConfig {
        final String cluster;
        @Nullable
        final String edsServiceName;
        @Nullable
        final Bootstrapper.ServerInfo lrsServerInfo;
        @Nullable
        final Long maxConcurrentRequests;
        @Nullable
        final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
        final List<Endpoints.DropOverload> dropCategories;
        final ServiceConfigUtil.PolicySelection childPolicy;

        ClusterImplConfig(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, List<Endpoints.DropOverload> dropCategories, ServiceConfigUtil.PolicySelection childPolicy, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            this.cluster = Preconditions.checkNotNull(cluster, "cluster");
            this.edsServiceName = edsServiceName;
            this.lrsServerInfo = lrsServerInfo;
            this.maxConcurrentRequests = maxConcurrentRequests;
            this.tlsContext = tlsContext;
            this.dropCategories = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropCategories, "dropCategories")));
            this.childPolicy = Preconditions.checkNotNull(childPolicy, "childPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("cluster", this.cluster).add("edsServiceName", this.edsServiceName).add("lrsServerInfo", this.lrsServerInfo).add("maxConcurrentRequests", this.maxConcurrentRequests).add("dropCategories", this.dropCategories).add("childPolicy", this.childPolicy).toString();
        }
    }
}

