/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleChecksumBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$mcJ$sp;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\rh!B\u00181\u0001IB\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!\u00111A\u0005\u0002MC\u0001B\u0017\u0001\u0003\u0002\u0004%\ta\u0017\u0005\tC\u0002\u0011\t\u0011)Q\u0005)\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003e\u0011\u0015Q\b\u0001\"\u0001|\u0011%\t\t\u0001\u0001EC\u0002\u0013%1\u000bC\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011Q\u0003\u0001!\u0002\u0013\t9\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!A\u0011\u0011\u0005\u0001!\u0002\u0013\tY\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003G\u0001A\u0011AA5\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bC\u0011\"!&\u0001#\u0003%\t!a&\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"I\u0011\u0011\u0019\u0001\u0012\u0002\u0013%\u0011q\u0013\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011%\t\t\u000eAI\u0001\n\u0013\t9\nC\u0004\u0002T\u0002!I!!6\t\u0013\u0005\u0005\b!%A\u0005\n\u0005]\u0005bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003H\u0001!\tA!\u0013\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!Q\u000f\u0001\u0005B\t]\u0004b\u0002BC\u0001\u0011\u0005#q\u0011\u0005\t\u0005/\u0003A\u0011\u0001\u0019\u0003\u001a\"9!1\u0015\u0001\u0005\u0002\t\u0015\u0006\"\u0003BY\u0001E\u0005I\u0011AAL\u0011\u001d\u0011\u0019\f\u0001C!\u0005kCqAa/\u0001\t\u0003\u0012i\fC\u0004\u0003F\u0002!\tEa2\b\u0011\t%\u0007\u0007#\u00013\u0005\u00174qa\f\u0019\t\u0002I\u0012i\r\u0003\u0004{S\u0011\u0005!q\u001a\u0005\n\u0005#L#\u0019!C\u0001\u0005'DqA!6*A\u0003%A\u000eC\u0005\u0003X&\n\n\u0011\"\u0001\u0003Z\"I!Q\\\u0015\u0012\u0002\u0013\u0005!q\u001c\u0002\u001a\u0013:$W\r_*ik\u001a4G.\u001a\"m_\u000e\\'+Z:pYZ,'O\u0003\u00022e\u000591\u000f[;gM2,'BA\u001a5\u0003\u0015\u0019\b/\u0019:l\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\u0014\u000b\u0001IthQ%\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0015)D\u00011\u0013\t\u0011\u0005G\u0001\u000bTQV4g\r\\3CY>\u001c7NU3t_24XM\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rJ\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw\r\u0005\u0002A\u0015&\u00111\n\r\u0002\u0013\u001b&<'/\u0019;bE2,'+Z:pYZ,'/\u0001\u0003d_:47\u0001\u0001\t\u0003\u001fBk\u0011AM\u0005\u0003#J\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s+\u0005!\u0006CA+Y\u001b\u00051&BA,3\u0003\u001d\u0019Ho\u001c:bO\u0016L!!\u0017,\u0003\u0019\tcwnY6NC:\fw-\u001a:\u0002#}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002]?B\u0011!(X\u0005\u0003=n\u0012A!\u00168ji\"9\u0001mAA\u0001\u0002\u0004!\u0016a\u0001=%c\u0005qqL\u00197pG.l\u0015M\\1hKJ\u0004\u0013\u0001\u0006;bg.LE-T1qg\u001a{'o\u00155vM\u001adW-F\u0001e!\u0011)'\u000e\\8\u000e\u0003\u0019T!a\u001a5\u0002\tU$\u0018\u000e\u001c\u0006\u0002S\u0006!!.\u0019<b\u0013\tYgMA\u0002NCB\u0004\"AO7\n\u00059\\$aA%oiB\u0019\u0001\u000f\u001e<\u000e\u0003ET!A]:\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002he%\u0011Q/\u001d\u0002\f\u001fB,g\u000eS1tQN+G\u000f\u0005\u0002;o&\u0011\u0001p\u000f\u0002\u0005\u0019>tw-A\u000buCN\\\u0017\nZ'baN4uN]*ik\u001a4G.\u001a\u0011\u0002\rqJg.\u001b;?)\u0011aXP`@\u0011\u0005\u0001\u0003\u0001\"\u0002'\b\u0001\u0004q\u0005b\u0002*\b!\u0003\u0005\r\u0001\u0016\u0005\bE\u001e\u0001\n\u00111\u0001e\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u00035!(/\u00198ta>\u0014HoQ8oMV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\t\"\u0004\u0002\u0002\f)\u0019q-!\u0004\u000b\u0007\u0005=!'A\u0004oKR<xN]6\n\t\u0005M\u00111\u0002\u0002\u000e)J\fgn\u001d9peR\u001cuN\u001c4\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA\u0005!\"/Z7pi\u0016\u001c\u0006.\u001e4gY\u0016l\u0015\r\u001f#jg.,\"!a\u0007\u0011\ti\niB^\u0005\u0004\u0003?Y$AB(qi&|g.A\u000bsK6|G/Z*ik\u001a4G.Z'bq\u0012K7o\u001b\u0011\u0002\u0017\u001d,G\u000fR1uC\u001aKG.\u001a\u000b\u0007\u0003O\t\u0019$a\u000e\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fi\u0003\tIw.\u0003\u0003\u00022\u0005-\"\u0001\u0002$jY\u0016Da!!\u000e\u000e\u0001\u0004a\u0017!C:ik\u001a4G.Z%e\u0011\u0019\tI$\u0004a\u0001m\u0006)Q.\u00199JI\u0006\tr-\u001a;Ti>\u0014X\rZ*ik\u001a4G.Z:\u0015\u0005\u0005}\u0002CBA!\u0003#\n9F\u0004\u0003\u0002D\u00055c\u0002BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%S*\u0001\u0004=e>|GOP\u0005\u0002y%\u0019\u0011qJ\u001e\u0002\u000fA\f7m[1hK&!\u00111KA+\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001fZ\u0004c\u0001!\u0002Z%\u0019\u00111\f\u0019\u0003!MCWO\u001a4mK\ncwnY6J]\u001a|\u0017!F4fiNCWO\u001a4mK\nKH/Z:Ti>\u0014X\r\u001a\u000b\u0002m\u0006q1M]3bi\u0016$V-\u001c9GS2,G\u0003BA\u0014\u0003KBq!a\u001a\u0011\u0001\u0004\t9#\u0001\u0003gS2,G\u0003CA\u0014\u0003W\ni'a\u001c\t\r\u0005U\u0012\u00031\u0001m\u0011\u0019\tI$\u0005a\u0001m\"9\u0011\u0011O\tA\u0002\u0005M\u0014\u0001\u00023jeN\u0004RAOA\u000f\u0003k\u0002RAOA<\u0003wJ1!!\u001f<\u0005\u0015\t%O]1z!\u0011\ti(!\"\u000f\t\u0005}\u0014\u0011\u0011\t\u0004\u0003\u000bZ\u0014bAABw\u00051\u0001K]3eK\u001aLA!a\"\u0002\n\n11\u000b\u001e:j]\u001eT1!a!<\u000319W\r^%oI\u0016Dh)\u001b7f)!\t9#a$\u0002\u0012\u0006M\u0005BBA\u001b%\u0001\u0007A\u000e\u0003\u0004\u0002:I\u0001\rA\u001e\u0005\n\u0003c\u0012\u0002\u0013!a\u0001\u0003g\nacZ3u\u0013:$W\r\u001f$jY\u0016$C-\u001a4bk2$HeM\u000b\u0003\u00033SC!a\u001d\u0002\u001c.\u0012\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003%)hn\u00195fG.,GMC\u0002\u0002(n\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY+!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fhKRlUM]4fI\ncwnY6ECR\fg)\u001b7f)1\t9#!-\u00026\u0006]\u00161XA`\u0011\u001d\t\u0019\f\u0006a\u0001\u0003w\nQ!\u00199q\u0013\u0012Da!!\u000e\u0015\u0001\u0004a\u0007BBA])\u0001\u0007A.\u0001\btQV4g\r\\3NKJ<W-\u00133\t\r\u0005uF\u00031\u0001m\u0003!\u0011X\rZ;dK&#\u0007\"CA9)A\u0005\t\u0019AA:\u0003\u0001:W\r^'fe\u001e,GM\u00117pG.$\u0015\r^1GS2,G\u0005Z3gCVdG\u000fJ\u001b\u0002/\u001d,G/T3sO\u0016$'\t\\8dW&sG-\u001a=GS2,G\u0003DA\u0014\u0003\u000f\fI-a3\u0002N\u0006=\u0007bBAZ-\u0001\u0007\u00111\u0010\u0005\u0007\u0003k1\u0002\u0019\u00017\t\r\u0005ef\u00031\u0001m\u0011\u0019\tiL\u0006a\u0001Y\"I\u0011\u0011\u000f\f\u0011\u0002\u0003\u0007\u00111O\u0001\"O\u0016$X*\u001a:hK\u0012\u0014En\\2l\u0013:$W\r\u001f$jY\u0016$C-\u001a4bk2$H%N\u0001\u0017O\u0016$X*\u001a:hK\u0012\u0014En\\2l\u001b\u0016$\u0018MR5mKRa\u0011qEAl\u00033\fY.!8\u0002`\"9\u00111\u0017\rA\u0002\u0005m\u0004BBA\u001b1\u0001\u0007A\u000e\u0003\u0004\u0002:b\u0001\r\u0001\u001c\u0005\u0007\u0003{C\u0002\u0019\u00017\t\u0013\u0005E\u0004\u0004%AA\u0002\u0005M\u0014\u0001I4fi6+'oZ3e\u00052|7m['fi\u00064\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\nqB]3n_Z,G)\u0019;b\u0005fl\u0015\r\u001d\u000b\u00069\u0006\u001d\u0018\u0011\u001e\u0005\u0007\u0003kQ\u0002\u0019\u00017\t\r\u0005e\"\u00041\u0001w\u0003U\u0019\u0007.Z2l\u0013:$W\r_!oI\u0012\u000bG/\u0019$jY\u0016$\u0002\"a<\u0002r\u0006U\u0018\u0011 \t\u0005u\u0005]d\u000fC\u0004\u0002tn\u0001\r!a\n\u0002\u000b%tG-\u001a=\t\u000f\u0005]8\u00041\u0001\u0002(\u0005!A-\u0019;b\u0011\u0019\tYp\u0007a\u0001Y\u00061!\r\\8dWN\fq\u0003];u'\",hM\u001a7f\u00052|7m[!t'R\u0014X-Y7\u0015\r\t\u0005!Q\u0002B\f!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0003\u001b\taa\u00197jK:$\u0018\u0002\u0002B\u0006\u0005\u000b\u0011Ac\u0015;sK\u0006l7)\u00197mE\u0006\u001c7nV5uQ&#\u0005b\u0002B\b9\u0001\u0007!\u0011C\u0001\bE2|7m[%e!\r)&1C\u0005\u0004\u0005+1&a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\b\u00053a\u0002\u0019\u0001B\u000e\u0003E\u0019XM]5bY&TXM]'b]\u0006<WM\u001d\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005\u001a\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0003&\t}!!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\u0006\u0011r-\u001a;NS\u001e\u0014\u0018\r^5p]\ncwnY6t)\u0011\u0011YCa\u0011\u0011\r\u0005\u0005#Q\u0006B\u0019\u0013\u0011\u0011y#!\u0016\u0003\t1K7\u000f\u001e\t\bu\tM\"\u0011\u0003B\u001c\u0013\r\u0011)d\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\te\"qH\u0007\u0003\u0005wQAA!\u0010\u0002\u000e\u00051!-\u001e4gKJLAA!\u0011\u0003<\tiQ*\u00198bO\u0016$')\u001e4gKJDqA!\u0012\u001e\u0001\u0004\t9&\u0001\ttQV4g\r\\3CY>\u001c7.\u00138g_\u0006QrO]5uK6+G/\u00193bi\u00064\u0015\u000e\\3B]\u0012\u001cu.\\7jiRYALa\u0013\u0003N\t=#1\u000bB,\u0011\u0019\t)D\ba\u0001Y\"1\u0011\u0011\b\u0010A\u0002YDqA!\u0015\u001f\u0001\u0004\ty/A\u0004mK:<G\u000f[:\t\u000f\tUc\u00041\u0001\u0002p\u0006I1\r[3dWN,Xn\u001d\u0005\b\u00053r\u0002\u0019AA\u0014\u0003\u001d!\u0017\r^1U[B\f\u0011c\u001e:ji\u0016lU\r^1eCR\fg)\u001b7f)%a&q\fB2\u0005O\u0012Y\u0007C\u0004\u0003b}\u0001\r!a<\u0002\u00155,G/\u0019,bYV,7\u000fC\u0004\u0003f}\u0001\r!a\n\u0002\u000fQl\u0007OR5mK\"9!\u0011N\u0010A\u0002\u0005\u001d\u0012A\u0003;be\u001e,GOR5mK\"9!QN\u0010A\u0002\t=\u0014A\u00049s_B\fw-\u0019;f\u000bJ\u0014xN\u001d\t\u0004u\tE\u0014b\u0001B:w\t9!i\\8mK\u0006t\u0017AE4fi6+'oZ3e\u00052|7m\u001b#bi\u0006$bA!\u001f\u0003|\t\r\u0005CBA!\u0003#\u00129\u0004C\u0004\u0003\u0010\u0001\u0002\rA! \u0011\u0007U\u0013y(C\u0002\u0003\u0002Z\u0013Ac\u00155vM\u001adW-T3sO\u0016$'\t\\8dW&#\u0007bBA9A\u0001\u0007\u00111O\u0001\u0013O\u0016$X*\u001a:hK\u0012\u0014En\\2l\u001b\u0016$\u0018\r\u0006\u0004\u0003\n\nM%Q\u0013\t\u0005\u0005\u0017\u0013y)\u0004\u0002\u0003\u000e*\u0019\u0011'!\u0004\n\t\tE%Q\u0012\u0002\u0010\u001b\u0016\u0014x-\u001a3CY>\u001c7.T3uC\"9!qB\u0011A\u0002\tu\u0004bBA9C\u0001\u0007\u00111O\u0001\rO\u0016$8\t[3dWN,Xn\u001d\u000b\u0007\u0003_\u0014YJa(\t\u000f\tu%\u00051\u0001\u0002(\u0005a1\r[3dWN,XNR5mK\"1!\u0011\u0015\u0012A\u00021\f\u0001B\u00197pG.tU/\\\u0001\u0010O\u0016$8\t[3dWN,XNR5mKRQ\u0011q\u0005BT\u0005S\u0013YKa,\t\r\u0005U2\u00051\u0001m\u0011\u0019\tId\ta\u0001m\"9!QV\u0012A\u0002\u0005m\u0014!C1mO>\u0014\u0018\u000e\u001e5n\u0011%\t\th\tI\u0001\u0002\u0004\t\u0019(A\rhKR\u001c\u0005.Z2lgVlg)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014\u0001D4fi\ncwnY6ECR\fGC\u0002B\u001c\u0005o\u0013I\fC\u0004\u0003\u0010\u0015\u0002\rA!\u0005\t\u0013\u0005ET\u0005%AA\u0002\u0005M\u0014aE4fi\ncwnY6t\r>\u00148\u000b[;gM2,GC\u0002B`\u0005\u0003\u0014\u0019\r\u0005\u0004\u0002B\u0005E#\u0011\u0003\u0005\u0007\u0003k1\u0003\u0019\u00017\t\r\u0005eb\u00051\u0001w\u0003\u0011\u0019Ho\u001c9\u0015\u0003q\u000b\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<feB\u0011\u0001)K\n\u0003Se\"\"Aa3\u0002\u001d9{u\nU0S\u000b\u0012+6)R0J\tV\tA.A\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u001c\u0016\u0004)\u0006m\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003b*\u001aA-a'")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging,
MigratableResolver {
    private BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    private final SparkConf conf;
    private BlockManager _blockManager;
    private final Map<Object, OpenHashSet<Object>> taskIdMapsForShuffle;
    private final TransportConf transportConf;
    private final Option<Object> remoteShuffleMaxDisk;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Map<Object, OpenHashSet<Object>> $lessinit$greater$default$3() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$3();
    }

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManager _blockManager() {
        return this._blockManager;
    }

    public void _blockManager_$eq(BlockManager x$1) {
        this._blockManager = x$1;
    }

    public Map<Object, OpenHashSet<Object>> taskIdMapsForShuffle() {
        return this.taskIdMapsForShuffle;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    public BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager() {
        if (!this.bitmap$0) {
            return this.blockManager$lzycompute();
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private Option<Object> remoteShuffleMaxDisk() {
        return this.remoteShuffleMaxDisk;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    @Override
    public Seq<ShuffleBlockInfo> getStoredShuffles() {
        Seq<BlockId> allBlocks = this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getAllBlocks();
        return (Seq)allBlocks.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlockId blockId = x0$1;
            if (blockId instanceof ShuffleIndexBlockId) {
                ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                int shuffleId = shuffleIndexBlockId.shuffleId();
                long mapId = shuffleIndexBlockId.mapId();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new ShuffleBlockInfo(shuffleId, mapId)));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private long getShuffleBytesStored() {
        Seq shuffleFiles = (Seq)this.getStoredShuffles().map((Function1 & Serializable & scala.Serializable)si -> this.getDataFile(si.shuffleId(), si.mapId()), Seq$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)shuffleFiles.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public File createTempFile(File file) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().createTempFileWith(file);
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    private File getMergedBlockDataFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedDataBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private File getMergedBlockIndexFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedIndexBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private Option<String[]> getMergedBlockIndexFile$default$5() {
        return None$.MODULE$;
    }

    private File getMergedBlockMetaFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedMetaBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
        }
        file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
        file.elem = this.getChecksumFile(shuffleId, mapId, this.conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Error deleting checksum ").append(((File)file$1.elem).getPath()).toString());
            return;
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block12: {
            long[] lArray;
            block11: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block11;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        if (data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))) {
            return lengths;
        }
        return null;
    }

    @Override
    public StreamCallbackWithID putShuffleBlockAsStream(BlockId blockId, SerializerManager serializerManager) {
        File file;
        this.remoteShuffleMaxDisk().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxBytes -> {
            long bytesUsed = this.getShuffleBytesStored();
            if (maxBytes < bytesUsed) {
                throw SparkException$.MODULE$.internalError(new StringBuilder(37).append("Not storing remote shuffles ").append(bytesUsed).append(" exceeds ").append(maxBytes).toString(), "SHUFFLE");
            }
        });
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleIndexBlockId) {
            ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId2;
            int shuffleId = shuffleIndexBlockId.shuffleId();
            long mapId = shuffleIndexBlockId.mapId();
            file = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        } else if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            file = this.getDataFile(shuffleId, mapId);
        } else {
            throw SparkException$.MODULE$.internalError(new StringBuilder(38).append("Unexpected shuffle block transfer ").append(blockId).append(" as ").append(blockId.getClass().getSimpleName()).toString(), "SHUFFLE");
        }
        File file2 = file;
        File fileTmp = this.createTempFile(file2);
        WritableByteChannel channel = Channels.newChannel(new FileOutputStream(fileTmp));
        return new StreamCallbackWithID(this, blockId, channel, fileTmp, file2){
            private final /* synthetic */ IndexShuffleBlockResolver $outer;
            private final BlockId blockId$3;
            private final WritableByteChannel channel$1;
            private final File fileTmp$1;
            private final File file$2;

            public ByteBuffer getCompletionResponse() {
                return super.getCompletionResponse();
            }

            public String getID() {
                return this.blockId$3.name();
            }

            public void onData(String streamId, ByteBuffer buf) {
                while (buf.hasRemaining()) {
                    this.channel$1.write(buf);
                }
            }

            public void onComplete(String streamId) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Done receiving shuffle block ").append($this.blockId$3).append(", now storing on local disk.").toString());
                this.channel$1.close();
                long diskSize = this.fileTmp$1.length();
                $anon$1 var5_3 = this;
                synchronized (var5_3) {
                    Object object = this.file$2.exists() ? BoxesRunTime.boxToBoolean((boolean)this.file$2.delete()) : BoxedUnit.UNIT;
                    if (!this.fileTmp$1.renameTo(this.file$2)) {
                        throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(this.fileTmp$1, this.file$2);
                    }
                }
                BlockId blockId = this.blockId$3;
                if (blockId instanceof ShuffleIndexBlockId) {
                    ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                    int shuffleId = shuffleIndexBlockId.shuffleId();
                    long mapId = shuffleIndexBlockId.mapId();
                    OpenHashSet mapTaskIds = this.$outer.taskIdMapsForShuffle().computeIfAbsent(BoxesRunTime.boxToInteger((int)shuffleId), x$2 -> $anon$1.$anonfun$onComplete$2(BoxesRunTime.unboxToInt((Object)x$2)));
                    mapTaskIds.add$mcJ$sp(mapId);
                } else if (blockId instanceof ShuffleDataBlockId) {
                    ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId;
                    int shuffleId = shuffleDataBlockId.shuffleId();
                    long mapId = shuffleDataBlockId.mapId();
                    OpenHashSet mapTaskIds = this.$outer.taskIdMapsForShuffle().computeIfAbsent(BoxesRunTime.boxToInteger((int)shuffleId), x$3 -> $anon$1.$anonfun$onComplete$3(BoxesRunTime.unboxToInt((Object)x$3)));
                    mapTaskIds.add$mcJ$sp(mapId);
                }
                this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus(this.blockId$3, new BlockStatus(StorageLevel$.MODULE$.DISK_ONLY(), 0L, diskSize), this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus$default$3());
            }

            public void onFailure(String streamId, Throwable cause) {
                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$3).toString(), cause);
                this.channel$1.close();
                this.fileTmp$1.delete();
            }

            public static final /* synthetic */ OpenHashSet $anonfun$onComplete$2(int x$2) {
                return new OpenHashSet$mcJ$sp(8, (ClassTag<Object>)ClassTag$.MODULE$.Long());
            }

            public static final /* synthetic */ OpenHashSet $anonfun$onComplete$3(int x$3) {
                return new OpenHashSet$mcJ$sp(8, (ClassTag<Object>)ClassTag$.MODULE$.Long());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
                this.channel$1 = channel$1;
                this.fileTmp$1 = fileTmp$1;
                this.file$2 = file$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 ), $anonfun$onFailure$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 )}, serializedLambda);
            }
        };
    }

    @Override
    public List<Tuple2<BlockId, ManagedBuffer>> getMigrationBlocks(ShuffleBlockInfo shuffleBlockInfo) {
        List list;
        block4: {
            try {
                int shuffleId = shuffleBlockInfo.shuffleId();
                long mapId = shuffleBlockInfo.mapId();
                File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                long indexFileSize = indexFile.length();
                FileSegmentManagedBuffer indexBlockData = new FileSegmentManagedBuffer(this.transportConf(), indexFile, 0L, indexFileSize);
                File dataFile = this.getDataFile(shuffleId, mapId);
                ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                FileSegmentManagedBuffer dataBlockData = new FileSegmentManagedBuffer(this.transportConf(), dataFile, 0L, dataFile.length());
                if (!indexFile.exists()) {
                    throw SparkException$.MODULE$.internalError("Index file is deleted already.", "SHUFFLE");
                }
                if (dataFile.exists()) {
                    list = new .colon.colon((Object)new Tuple2((Object)dataBlockId, (Object)dataBlockData), (List)new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$));
                    break block4;
                }
                list = new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$);
            }
            catch (Exception exception) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Failed to resolve shuffle block ").append(shuffleBlockInfo).append(". ").append("This is expected to occur if a block is removed after decommissioning has started.").toString());
                list = List$.MODULE$.empty();
            }
        }
        return list;
    }

    public void writeMetadataFileAndCommit(int shuffleId, long mapId, long[] lengths, long[] checksums, File dataTmp) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = this.createTempFile(indexFile);
        boolean checksumEnabled = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(checksums)).nonEmpty();
        if (checksumEnabled) {
            Predef$.MODULE$.assert(lengths.length == checksums.length, (Function0 & Serializable & scala.Serializable)() -> "The size of partition lengths and checksums should be equal");
            File checksumFile = this.getChecksumFile(shuffleId, mapId, this.conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
            tuple22 = new Tuple2((Object)new Some((Object)checksumFile), (Object)new Some((Object)this.createTempFile(checksumFile)));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option checksumFileOpt = (Option)tuple2._1();
        Option checksumTmpOpt = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)checksumFileOpt, (Object)checksumTmpOpt);
        Option checksumFileOpt2 = (Option)tuple23._1();
        Option checksumTmpOpt2 = (Option)tuple23._2();
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    if (checksumEnabled) {
                        long[] existingChecksums = this.getChecksums((File)checksumFileOpt2.get(), checksums.length);
                        if (existingChecksums != null) {
                            System.arraycopy(existingChecksums, 0, checksums, 0, lengths.length);
                        } else {
                            this.writeMetadataFile(checksums, (File)checksumTmpOpt2.get(), (File)checksumFileOpt2.get(), false);
                        }
                    }
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    long[] offsets = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).scanLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                    this.writeMetadataFile(offsets, indexTmp, indexFile, true);
                    Object object2 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(dataTmp, dataFile);
                    }
                    ((IterableLike)Option$.MODULE$.option2Iterable(checksumTmpOpt2).zip((GenIterable)Option$.MODULE$.option2Iterable(checksumFileOpt2), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$3(this, checksums, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Shuffle index for mapId ").append(mapId).append(": ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).mkString("[", ",", "]")).toString());
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
            checksumTmpOpt2.foreach((Function1 & Serializable & scala.Serializable)checksumTmp -> {
                IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$7(this, checksumTmp);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void writeMetadataFile(long[] metaValues, File tmpFile, File targetFile, boolean propagateError) {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metaValues)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> out.writeLong(x$1)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
        Object object = targetFile.exists() ? BoxesRunTime.boxToBoolean((boolean)targetFile.delete()) : BoxedUnit.UNIT;
        if (!tmpFile.renameTo(targetFile)) {
            if (propagateError) {
                throw SparkCoreErrors$.MODULE$.failedRenameTempFileError(tmpFile, targetFile);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("fail to rename file ").append(tmpFile).append(" to ").append(targetFile).toString());
            return;
        }
    }

    @Override
    public Seq<ManagedBuffer> getMergedBlockData(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        File dataFile = this.getMergedBlockDataFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        LongBuffer offsets = (LongBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new DataInputStream(Files.newInputStream(indexFile.toPath(), new OpenOption[0])), (Function1 & Serializable & scala.Serializable)dis -> {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            dis.readFully(buffer.array());
            return buffer.asLongBuffer();
        });
        int numChunks = size / 8 - 1;
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChunks).map((Function1 & Serializable & scala.Serializable)index -> IndexShuffleBlockResolver.$anonfun$getMergedBlockData$3(this, dataFile, offsets, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Option<String[]> getMergedBlockDataFile$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        File metaFile = this.getMergedBlockMetaFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.transportConf(), metaFile, 0L, metaFile.length());
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    private Option<String[]> getMergedBlockMetaFile$default$5() {
        return None$.MODULE$;
    }

    public long[] getChecksums(File checksumFile, int blockNum) {
        ArrayBuffer checksums;
        block8: {
            long[] lArray;
            block9: {
                if (!checksumFile.exists()) {
                    return null;
                }
                checksums = new ArrayBuffer();
                try (FilterInputStream in = null;){
                    try {
                        in = new DataInputStream(new NioBufferedFileInputStream(checksumFile));
                        while (checksums.size() < blockNum) {
                            checksums.$plus$eq((Object)BoxesRunTime.boxToLong((long)((DataInputStream)in).readLong()));
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof IOException ? true : throwable2 instanceof EOFException) {
                            lArray = null;
                            break block9;
                        }
                        throw throwable;
                    }
                }
            }
            return lArray;
        }
        return (long[])checksums.toArray(ClassTag$.MODULE$.Long());
    }

    public File getChecksumFile(int shuffleId, long mapId, String algorithm, Option<String[]> dirs) {
        ShuffleChecksumBlockId blockId = new ShuffleChecksumBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        String fileName = ShuffleChecksumHelper.getChecksumFileName((String)blockId.name(), (String)algorithm);
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)fileName))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(fileName));
    }

    public Option<String[]> getChecksumFile$default$4() {
        return None$.MODULE$;
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw SparkException$.MODULE$.internalError(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString(), "SHUFFLE");
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw SparkException$.MODULE$.internalError(new StringBuilder(99).append("SPARK-22982: Incorrect channel position after index").append(" file reads: expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString(), "SHUFFLE");
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public Seq<BlockId> getBlocksForShuffle(int shuffleId, long mapId) {
        return (Seq)new .colon.colon((Object)new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)new .colon.colon((Object)new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)Nil$.MODULE$));
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$3(IndexShuffleBlockResolver $this, long[] checksums$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            File checksumTmp = (File)tuple2._1();
            File checksumFile = (File)tuple2._2();
            try {
                $this.writeMetadataFile(checksums$1, checksumTmp, checksumFile, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write checksum file", e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$7(IndexShuffleBlockResolver $this, File checksumTmp) {
        if (checksumTmp.exists()) {
            try {
                if (!checksumTmp.delete()) {
                    $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to delete temporary checksum file ").append("at ").append(checksumTmp.getAbsolutePath()).toString());
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to delete temporary checksum file ").append("at ").append(checksumTmp.getAbsolutePath()).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ FileSegmentManagedBuffer $anonfun$getMergedBlockData$3(IndexShuffleBlockResolver $this, File dataFile$1, LongBuffer offsets$1, int index) {
        return new FileSegmentManagedBuffer($this.transportConf(), dataFile$1, offsets$1.get(index), offsets$1.get(index + 1) - offsets$1.get(index));
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager, Map<Object, OpenHashSet<Object>> taskIdMapsForShuffle) {
        this.conf = conf;
        this._blockManager = _blockManager;
        this.taskIdMapsForShuffle = taskIdMapsForShuffle;
        ShuffleBlockResolver.$init$(this);
        Logging.$init$((Logging)this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        this.remoteShuffleMaxDisk = (Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_DISK_SIZE());
    }
}

