/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.metastore;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogPartition;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.hive.catalog.IntercomAPIModel;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hive.metastore.DSSHiveCatalogToHiveConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class DSSCatalogMetastoreClientDelegate {
    public static final String API_PREFIX = "/dip/api/tintercom/";
    private static final Logger logger = Logger.getLogger((String)"dku.hive.catalog");
    private static final List<Role> implicitRoles = Lists.newArrayList((Object[])new Role[]{new Role("public", 0, "public")});
    private final TicketBasedIntercomAPIClient apiClient;
    private final HiveConf conf;

    public DSSCatalogMetastoreClientDelegate(HiveConf conf, TicketBasedIntercomAPIClient apiClient, Warehouse wh) throws MetaException {
        this.conf = conf;
        this.apiClient = apiClient;
    }

    private MetaException wrap(String msg, Exception e) {
        MetaException me = new MetaException(msg);
        me.initCause((Throwable)e);
        return me;
    }

    public void createDatabase(Database database) throws TException {
        throw new UnsupportedOperationException("createDatabase is not supported");
    }

    public Database getDatabase(String name) throws TException {
        try {
            IntercomAPIModel.ListDatabasesResponse resp = (IntercomAPIModel.ListDatabasesResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-databases", IntercomAPIModel.ListDatabasesResponse.class, (Object)new IntercomAPIModel.ListDatabasesQuery());
            if (resp.databases.contains(name)) {
                return DSSHiveCatalogToHiveConverter.convertDatabase(name);
            }
            if ("default".equals(name)) {
                return DSSHiveCatalogToHiveConverter.convertDatabase(name);
            }
            throw new NoSuchObjectException("Database not found in DSS catalog: " + name);
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to get database", e);
        }
    }

    public List<String> getDatabases(String pattern) throws TException {
        try {
            if (pattern == null || pattern.equals("*")) {
                pattern = ".*";
            }
            IntercomAPIModel.ListDatabasesResponse resp = (IntercomAPIModel.ListDatabasesResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-databases", IntercomAPIModel.ListDatabasesResponse.class, (Object)new IntercomAPIModel.ListDatabasesQuery());
            ArrayList ret = Lists.newArrayList();
            for (String db : resp.databases) {
                if (!Pattern.matches(pattern, db)) continue;
                ret.add(db);
            }
            if (!ret.contains("default") && Pattern.matches(pattern, "default")) {
                ret.add("default");
            }
            return ret;
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to get database", e);
        }
    }

    public void alterDatabase(String databaseName, Database database) throws TException {
        throw new UnsupportedOperationException("alterDatabase is not supported");
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws TException {
        throw new UnsupportedOperationException("dropDatabase is not supported");
    }

    public boolean databaseExists(String dbName) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        try {
            this.getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
        return true;
    }

    public void createTable(Table tbl) throws TException {
        throw new UnsupportedOperationException("createTable is not supported");
    }

    public boolean tableExists(String databaseName, String tableName) throws TException {
        try {
            IntercomAPIModel.GetTableQuery gtq = new IntercomAPIModel.GetTableQuery();
            gtq.dbName = databaseName;
            gtq.tableName = tableName;
            IntercomAPIModel.GetTableResponse resp = (IntercomAPIModel.GetTableResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/get-table", IntercomAPIModel.GetTableResponse.class, (Object)gtq);
            return resp.found;
        }
        catch (Exception e) {
            String msg = "Unable to check table exist: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + String.valueOf(e));
        }
    }

    public Table getTable(String dbName, String tableName) throws TException {
        try {
            IntercomAPIModel.GetTableQuery gtq = new IntercomAPIModel.GetTableQuery();
            gtq.dbName = dbName;
            gtq.tableName = tableName;
            IntercomAPIModel.GetTableResponse resp = (IntercomAPIModel.GetTableResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/get-table", IntercomAPIModel.GetTableResponse.class, (Object)gtq);
            if (!resp.found) {
                throw new MetaException("Table not found db=" + dbName + " table=" + tableName);
            }
            return DSSHiveCatalogToHiveConverter.convertTable(resp.table);
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to get table", e);
        }
    }

    public List<String> getTables(String dbname, String pattern) throws TException {
        try {
            IntercomAPIModel.ListTablesQuery ltq = new IntercomAPIModel.ListTablesQuery();
            ltq.dbName = dbname;
            if (pattern == null || pattern.equals("*")) {
                pattern = ".*";
            }
            IntercomAPIModel.ListTablesResponse resp = (IntercomAPIModel.ListTablesResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-tables", IntercomAPIModel.ListTablesResponse.class, (Object)ltq);
            ArrayList ret = Lists.newArrayList();
            for (DSSHiveCatalogTable db : resp.tables) {
                if (!Pattern.matches(pattern, db.tableName)) continue;
                ret.add(db.tableName);
            }
            return ret;
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to list table", e);
        }
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws TException {
        this.getTable(databaseName, tableName);
        if (values != null) {
            throw new UnsupportedOperationException("Filtering partitions list is not supported");
        }
        IntercomAPIModel.ListPartitionsQuery ltq = new IntercomAPIModel.ListPartitionsQuery();
        ltq.dbName = databaseName;
        ltq.tableName = tableName;
        try {
            IntercomAPIModel.ListPartitionsResponse resp = (IntercomAPIModel.ListPartitionsResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-partitions", IntercomAPIModel.ListPartitionsResponse.class, (Object)ltq);
            ArrayList<String> ret = new ArrayList<String>();
            for (DSSHiveCatalogPartition cp : resp.partitions) {
                ret.add(cp.hivePartitionName);
            }
            return ret;
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to list table", e);
        }
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        Preconditions.checkNotNull(partitionNames, (Object)"partitionNames cannot be null");
        IntercomAPIModel.ListPartitionsQuery ltq = new IntercomAPIModel.ListPartitionsQuery();
        ltq.dbName = databaseName;
        ltq.tableName = tableName;
        try {
            IntercomAPIModel.ListPartitionsResponse resp = (IntercomAPIModel.ListPartitionsResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-partitions", IntercomAPIModel.ListPartitionsResponse.class, (Object)ltq);
            ArrayList<Partition> ret = new ArrayList<Partition>();
            for (DSSHiveCatalogPartition p : resp.partitions) {
                if (!partitionNames.contains(p.hivePartitionName)) continue;
                ret.add(DSSHiveCatalogToHiveConverter.convertPartition(resp.table, p));
            }
            return ret;
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to list table", e);
        }
    }

    public Partition getPartition(String dbName, String tblName, String partitionName) throws TException {
        List<String> values = DSSCatalogMetastoreClientDelegate.partitionNameToVals(partitionName);
        return this.getPartition(dbName, tblName, values);
    }

    public Partition getPartition(String dbName, String tblName, List<String> values) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Preconditions.checkNotNull(values, (Object)"values cannot be null");
        String hivePartitionName = StringUtils.join(values, (String)"/");
        IntercomAPIModel.GetPartitionQuery gtq = new IntercomAPIModel.GetPartitionQuery();
        gtq.dbName = dbName;
        gtq.tableName = tblName;
        gtq.hivePartitionName = hivePartitionName;
        try {
            IntercomAPIModel.GetPartitionResponse resp = (IntercomAPIModel.GetPartitionResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/get-partition", IntercomAPIModel.GetPartitionResponse.class, (Object)gtq);
            if (!resp.found) {
                logger.info((Object)("No partition dbName = " + dbName + ", tblName = " + tblName + ", values = " + String.valueOf(values)));
                return null;
            }
            return DSSHiveCatalogToHiveConverter.convertPartition(resp.table, resp.partition);
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to get partition", e);
        }
    }

    public List<Partition> getPartitions(String databaseName, String tableName, ExpressionTree filter, long max) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        IntercomAPIModel.ListPartitionsQuery ltq = new IntercomAPIModel.ListPartitionsQuery();
        ltq.dbName = databaseName;
        ltq.tableName = tableName;
        try {
            IntercomAPIModel.ListPartitionsResponse resp = (IntercomAPIModel.ListPartitionsResponse)this.apiClient.postObject("/dip/api/tintercom/hive/catalog/list-partitions", IntercomAPIModel.ListPartitionsResponse.class, (Object)ltq);
            ArrayList<Partition> ret = new ArrayList<Partition>();
            for (DSSHiveCatalogPartition p : resp.partitions) {
                logger.info((Object)("Matching partion  " + JSON.json((Object)p) + " against filter: " + JSON.json((Object)filter)));
                if (filter == null || PartitionFilterVerifier.matches(filter, resp.table, p)) {
                    ret.add(DSSHiveCatalogToHiveConverter.convertPartition(resp.table, p));
                    continue;
                }
                logger.info((Object)"no  match");
            }
            logger.info((Object)("Returning a list of " + ret.size() + "/" + resp.partitions.size() + " after filtering"));
            return ret;
        }
        catch (IOException e) {
            logger.warn((Object)"Call failed", (Throwable)e);
            throw this.wrap("Failed to list partitions", e);
        }
    }

    public static List<String> partitionNameToVals(String name) throws TException {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        if (name.isEmpty()) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Warehouse.makeSpecFromName((String)name);
        ArrayList vals = Lists.newArrayList();
        vals.addAll(map.values());
        return vals;
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) throws TException {
        if (principalType == PrincipalType.USER) {
            return implicitRoles;
        }
        throw new UnsupportedOperationException("listRoles is only supported for " + String.valueOf(PrincipalType.USER) + " Principal type");
    }

    public List<String> listRoleNames() throws TException {
        return Lists.newArrayList((Object[])new String[]{"public"});
    }

    public PrincipalPrivilegeSet getPrivilegeSet(HiveObjectRef objectRef, String user, List<String> groups) throws TException {
        return null;
    }

    public List<String> getFunctions(String dbName, String pattern) throws TException {
        return new ArrayList<String>();
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.getTable(db, tableName).getSd().getCols();
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws TException, UnknownTableException, UnknownDBException {
        return this.getTable(db, tableName).getSd().getCols();
    }

    private static class PartitionFilterVerifier
    extends ExpressionTree.TreeVisitor {
        private Map<String, String> pvalues = new HashMap<String, String>();
        private Exception exception;
        List<MatchState> matchStack = new ArrayList<MatchState>();

        private PartitionFilterVerifier(DSSHiveCatalogTable table, DSSHiveCatalogPartition partition) throws TException {
            ArrayList<String> values = new ArrayList<String>();
            for (String v : partition.hivePartitionName.split(",")) {
                String[] chunks = v.split("=");
                values.add(chunks[1]);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("VALUES= " + JSON.json(values)));
                logger.trace((Object)("PATITION KEYS= " + JSON.json((Object)table.partitionKeys)));
            }
            for (int i = 0; i < table.partitionKeys.size(); ++i) {
                this.pvalues.put(((SchemaColumn)table.partitionKeys.get(i)).getName(), (String)values.get(i));
            }
            this.matchStack.add(new MatchState());
        }

        private static boolean matches(ExpressionTree tree, DSSHiveCatalogTable table, DSSHiveCatalogPartition partition) throws TException {
            PartitionFilterVerifier verifier = new PartitionFilterVerifier(table, partition);
            logger.trace((Object)"Visiting");
            tree.accept((ExpressionTree.TreeVisitor)verifier);
            logger.trace((Object)"Visited");
            Validate.isTrue((verifier.matchStack.size() == 1 ? 1 : 0) != 0);
            Validate.isTrue((verifier.matchStack.get((int)0).matched.size() == 1 ? 1 : 0) != 0);
            return verifier.matchStack.get((int)0).matched.get(0);
        }

        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("BEGIN tree node op=" + String.valueOf(node.getAndOr())));
            }
            this.matchStack.add(new MatchState());
        }

        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("MID tree node op=" + String.valueOf(node.getAndOr())));
            }
        }

        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("END tree node op=" + String.valueOf(node.getAndOr())));
            }
            MatchState treeMatchState = this.matchStack.get(this.matchStack.size() - 1);
            this.matchStack.remove(this.matchStack.size() - 1);
            boolean treeMatches = false;
            switch (node.getAndOr()) {
                case AND: {
                    treeMatches = true;
                    for (Boolean ms : treeMatchState.matched) {
                        treeMatches &= ms.booleanValue();
                    }
                    break;
                }
                case OR: {
                    treeMatches = false;
                    for (Boolean ms : treeMatchState.matched) {
                        treeMatches |= ms.booleanValue();
                    }
                    break;
                }
            }
            this.matchStack.get((int)(this.matchStack.size() - 1)).matched.add(treeMatches);
        }

        protected boolean shouldStop() {
            return this.exception != null;
        }

        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("VISIT leaf " + node.keyName));
            }
            switch (node.operator) {
                case EQUALS: {
                    break;
                }
                default: {
                    this.exception = new MetaException("only EQUALS partition filter operator  is unsupported");
                    return;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Visiting node keyName=" + node.keyName + " val=" + String.valueOf(node.value) + " op=" + String.valueOf(node.operator)));
            }
            String val = this.pvalues.get(node.keyName);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("value for p:" + val));
            }
            boolean matches = StringUtils.equals((String)val, (String)String.valueOf(node.value));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("matched: " + matches));
            }
            this.matchStack.get((int)(this.matchStack.size() - 1)).matched.add(matches);
        }

        static class MatchState {
            List<Boolean> matched = new ArrayList<Boolean>();

            MatchState() {
            }
        }
    }
}

