/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverterFactory;
import com.amazonaws.glue.catalog.util.PartitionKey;
import com.amazonaws.glue.catalog.util.PartitionUtils;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.BatchDeletePartitionRequest;
import com.amazonaws.services.glue.model.BatchDeletePartitionResult;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.ErrorDetail;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PartitionError;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public final class BatchDeletePartitionsHelper {
    private static final Logger logger = Logger.getLogger(BatchDeletePartitionsHelper.class);
    private final AWSGlue client;
    private final String namespaceName;
    private final String tableName;
    private final String catalogId;
    private final List<Partition> partitions;
    private Map<PartitionKey, Partition> partitionMap;
    private TException firstTException;
    private CatalogToHiveConverter catalogToHiveConverter;

    public BatchDeletePartitionsHelper(AWSGlue client, String namespaceName, String tableName, String catalogId, List<Partition> partitions) {
        this.client = client;
        this.namespaceName = namespaceName;
        this.tableName = tableName;
        this.catalogId = catalogId;
        this.partitions = partitions;
        this.catalogToHiveConverter = CatalogToHiveConverterFactory.getCatalogToHiveConverter();
    }

    public BatchDeletePartitionsHelper deletePartitions() {
        this.partitionMap = PartitionUtils.buildPartitionMap(this.partitions);
        BatchDeletePartitionRequest request = new BatchDeletePartitionRequest().withDatabaseName(this.namespaceName).withTableName(this.tableName).withCatalogId(this.catalogId).withPartitionsToDelete(PartitionUtils.getPartitionValuesList(this.partitionMap));
        try {
            BatchDeletePartitionResult result = this.client.batchDeletePartition(request);
            this.processResult(result);
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown while deleting partitions in DataCatalog: ", (Throwable)e);
            this.firstTException = this.catalogToHiveConverter.wrapInHiveException(e);
            if (PartitionUtils.isInvalidUserInputException(e)) {
                this.setAllFailed();
            }
            this.checkIfPartitionsDeleted();
        }
        return this;
    }

    private void setAllFailed() {
        this.partitionMap.clear();
    }

    private void processResult(BatchDeletePartitionResult batchDeletePartitionsResult) {
        List partitionErrors = batchDeletePartitionsResult.getErrors();
        if (partitionErrors == null || partitionErrors.isEmpty()) {
            return;
        }
        logger.error((Object)String.format("BatchDeletePartitions failed to delete %d out of %d partitions. \n", partitionErrors.size(), this.partitionMap.size()));
        for (PartitionError partitionError : partitionErrors) {
            this.partitionMap.remove(new PartitionKey(partitionError.getPartitionValues()));
            ErrorDetail errorDetail = partitionError.getErrorDetail();
            logger.error((Object)errorDetail.toString());
            if (this.firstTException != null) continue;
            this.firstTException = this.catalogToHiveConverter.errorDetailToHiveException(errorDetail);
        }
    }

    private void checkIfPartitionsDeleted() {
        for (Partition partition : this.partitions) {
            if (this.partitionDeleted(partition)) continue;
            this.partitionMap.remove(new PartitionKey(partition));
        }
    }

    private boolean partitionDeleted(Partition partition) {
        GetPartitionRequest request = new GetPartitionRequest().withDatabaseName(partition.getDatabaseName()).withTableName(partition.getTableName()).withPartitionValues((Collection)partition.getValues()).withCatalogId(this.catalogId);
        try {
            GetPartitionResult result = this.client.getPartition(request);
            Partition partitionReturned = result.getPartition();
            return partitionReturned == null;
        }
        catch (EntityNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Get partition request %s failed. ", request.toString()), (Throwable)e);
            return false;
        }
    }

    public TException getFirstTException() {
        return this.firstTException;
    }

    public Collection<Partition> getPartitionsDeleted() {
        return this.partitionMap.values();
    }
}

