/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.IntegerType;
import java.util.Objects;
import java.util.Optional;

public class DefaultIntVector
extends AbstractColumnVector {
    private final int[] values;

    public DefaultIntVector(DataType dataType, int n, Optional<boolean[]> optional, int[] nArray) {
        super(n, dataType, optional);
        Preconditions.checkArgument((dataType instanceof IntegerType || dataType instanceof DateType ? 1 : 0) != 0);
        this.values = Objects.requireNonNull(nArray, "values is null");
        Preconditions.checkArgument((nArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{nArray.length, n});
    }

    @Override
    public int getInt(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

