/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionQuery;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.model.hive.QueryStatus;
import com.dataiku.hproxy.model.hive.ResultCount;
import com.dataiku.hproxy.server.hive.executor.IHiveExecutorImpl;
import com.dataiku.hproxy.server.hive.executor.IQueryHandler;
import com.dataiku.hproxy.server.hive.executor.SessionHandler;
import com.dataiku.hproxy.server.hive.executor.WrappedHiveException;
import com.dataiku.hproxy.utils.Reflector;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

class QueryHandler
implements IQueryHandler {
    private final Object stateWait = new Object();
    private volatile QueryStatus.HiveQueryState state = QueryStatus.HiveQueryState.DEAD;
    private final ExecutionQuery query;
    private final String identifier;
    private IHiveExecutorImpl hiveController;
    private final SessionHandler session;
    private boolean holdsSession = false;
    private String deathReason;
    private List<ColumnSchema> schema;
    private boolean killed = false;
    private long maxIdleTime = -1L;
    private final Object timingLock = new Object();
    private volatile boolean fetchFlag = false;
    private volatile long lastUsedTime;
    private long startTime;
    private long finishTime;
    private static Logger logger = Logger.getLogger(QueryHandler.class);
    private Future<Boolean> hiveExecutionResult;

    @Override
    public ExecutionQuery getQuery() {
        return this.query;
    }

    protected QueryHandler(ExecutionQuery query, String identifier) {
        this.query = query;
        this.identifier = identifier;
        this.session = null;
    }

    public QueryHandler(SessionHandler session, ExecutionQuery query, String identifier) {
        this.session = session;
        this.holdsSession = true;
        this.query = query;
        this.identifier = identifier;
        this.setState(QueryStatus.HiveQueryState.READY_TO_EXECUTE);
        session.registerUsage(this);
    }

    @Override
    public synchronized void setMaxIdleTime(long ms) {
        if (ms == -1L) {
            this.info("Disabled autokill");
        } else {
            this.info("Enabled autokill after " + ms + " ms");
        }
        this.maxIdleTime = ms;
    }

    @Override
    public synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStartTime() {
        Object object = this.timingLock;
        synchronized (object) {
            this.updateLastUsedTime();
            this.startTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinishTime() {
        Object object = this.timingLock;
        synchronized (object) {
            this.updateLastUsedTime();
            this.finishTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastUsedTime() {
        Object object = this.timingLock;
        synchronized (object) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        Object object = this.timingLock;
        synchronized (object) {
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        Object object = this.timingLock;
        synchronized (object) {
            return this.finishTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUsedTime() {
        Object object = this.timingLock;
        synchronized (object) {
            return this.lastUsedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeathReason() {
        Object object = this.timingLock;
        synchronized (object) {
            return this.deathReason;
        }
    }

    private synchronized void info(String str) {
        logger.info((Object)("[" + this.identifier + "] " + str));
    }

    private synchronized void info(String str, Throwable t) {
        logger.info((Object)("[" + this.identifier + "] " + str), t);
    }

    @Override
    public synchronized void startExecution() {
        assert (this.state == QueryStatus.HiveQueryState.READY_TO_EXECUTE);
        this.info("Prepare Hive query executor");
        this.hiveExecutionResult = this.session.getHiveThread().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    if (QueryHandler.this.killed) {
                        throw new Exception("Query [" + QueryHandler.this.identifier + "] has been killed");
                    }
                    QueryHandler.this.updateStartTime();
                    QueryHandler.this.info("Instanciate Hive controller");
                    QueryHandler.this.hiveController = (IHiveExecutorImpl)new Reflector(QueryHandler.this.session.getHiveThread().getClassLoader()).newInstance("com.dataiku.hproxy.sandbox.hive.executor.HiveExecutorImpl", new Object[0]);
                    QueryHandler.this.info("Initialize Hive controller");
                    QueryHandler.this.hiveController.initialize(QueryHandler.this.session.getSession(), QueryHandler.this.query);
                    QueryHandler.this.info("Start Hive query execution");
                    boolean ret = QueryHandler.this.hiveController.executeQuery();
                    QueryHandler.this.updateFinishTime();
                    QueryHandler.this.checkFinishedQuery(ret);
                    if (QueryHandler.this.releaseSession()) {
                        QueryHandler.this.session.give();
                    }
                    return ret;
                }
                catch (WrappedHiveException ex) {
                    QueryHandler.this.release();
                    if (QueryHandler.this.releaseSession()) {
                        QueryHandler.this.session.give();
                    }
                    QueryHandler.this.session.deregisterUsage(QueryHandler.this);
                    throw ex;
                }
            }
        });
        this.setState(QueryStatus.HiveQueryState.EXECUTING_QUERY);
    }

    private synchronized boolean releaseSession() {
        boolean ret = this.holdsSession;
        this.holdsSession = false;
        return ret;
    }

    @Override
    public synchronized List<ColumnSchema> getSchema() {
        return this.schema;
    }

    private synchronized void checkRunningQuery() {
        assert (this.state == QueryStatus.HiveQueryState.EXECUTING_QUERY);
        if (this.hiveExecutionResult.isDone()) {
            try {
                this.checkFinishedQuery(this.hiveExecutionResult.get());
            }
            catch (WrappedHiveException | ExecutionException e) {
                this.setState(QueryStatus.HiveQueryState.DEAD);
                Throwable t = e.getCause();
                this.info("Got error from Hive", t);
                this.deathReason = t.getMessage();
            }
            catch (InterruptedException e) {
                this.info("The single thread executor has been interrupted !");
                Thread.currentThread().interrupt();
                this.setState(QueryStatus.HiveQueryState.DEAD);
            }
        }
    }

    private void checkFinishedQuery(boolean hasResults) {
        try {
            if (hasResults) {
                this.setState(QueryStatus.HiveQueryState.READY_TO_FETCH);
                this.schema = this.hiveController.getSchema();
            } else {
                this.setState(QueryStatus.HiveQueryState.COMPLETE);
            }
        }
        catch (CancellationException e) {
            this.setState(QueryStatus.HiveQueryState.DEAD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setState(QueryStatus.HiveQueryState newState) {
        Object object = this.stateWait;
        synchronized (object) {
            if (newState != this.state) {
                this.info("State changed (" + String.valueOf(this.state) + " > " + String.valueOf(newState) + ")");
                this.state = newState;
                this.stateWait.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryStatus.HiveQueryState waitForNextState(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        Object object = this.stateWait;
        synchronized (object) {
            QueryStatus.HiveQueryState initialState = this.state;
            while (this.state != QueryStatus.HiveQueryState.DEAD && this.state != QueryStatus.HiveQueryState.COMPLETE && this.state != QueryStatus.HiveQueryState.READY_TO_FETCH && this.state == initialState) {
                long now = System.currentTimeMillis();
                long elapsed = now - start;
                long remaining = timeout - elapsed;
                if (timeout > 0L && remaining <= 0L) break;
                this.stateWait.wait(timeout);
            }
            return this.state;
        }
    }

    @Override
    public synchronized void update() {
        if (this.state == QueryStatus.HiveQueryState.EXECUTING_QUERY) {
            this.checkRunningQuery();
        }
    }

    @Override
    public synchronized Future<Long> getLowerBoundOnCount() {
        assert (this.state == QueryStatus.HiveQueryState.READY_TO_FETCH);
        return this.session.getHiveThread().submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                try {
                    QueryHandler.this.updateLastUsedTime();
                    QueryHandler.this.setFetchFlag(true);
                    Long l = QueryHandler.this.hiveController.getMostAdvancedFetcherPosition();
                    return l;
                }
                finally {
                    QueryHandler.this.setFetchFlag(false);
                    QueryHandler.this.updateLastUsedTime();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFetching() {
        Object object = this.timingLock;
        synchronized (object) {
            return this.fetchFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFetchFlag(boolean f) {
        Object object = this.timingLock;
        synchronized (object) {
            this.fetchFlag = f;
        }
    }

    @Override
    public synchronized Future<ExecutionResults> fetchResult(final long from, final long limit) {
        assert (this.state == QueryStatus.HiveQueryState.READY_TO_FETCH);
        this.info("Register new fetch request [offset=" + from + ", limit=" + limit + "]");
        return this.session.getHiveThread().submit(new Callable<ExecutionResults>(){

            @Override
            public ExecutionResults call() throws Exception {
                try {
                    QueryHandler.this.updateLastUsedTime();
                    QueryHandler.this.setFetchFlag(true);
                    if (QueryHandler.this.killed) {
                        throw new Exception("Query [" + QueryHandler.this.identifier + "] has been killed");
                    }
                    QueryHandler.this.info("Process fetch request [offset=" + from + ", limit=" + limit + "]");
                    ExecutionResults ret = QueryHandler.this.hiveController.fetchResults(from, limit);
                    QueryHandler.this.updateLastUsedTime();
                    ExecutionResults executionResults = ret;
                    return executionResults;
                }
                finally {
                    QueryHandler.this.setFetchFlag(false);
                    QueryHandler.this.updateLastUsedTime();
                }
            }
        });
    }

    @Override
    public synchronized Future<ResultCount> countResults(final long limit) {
        assert (this.state == QueryStatus.HiveQueryState.READY_TO_FETCH);
        this.info("Register new count request [limit=" + limit + "]");
        return this.session.getHiveThread().submit(new Callable<ResultCount>(){

            @Override
            public ResultCount call() throws Exception {
                try {
                    QueryHandler.this.setFetchFlag(true);
                    QueryHandler.this.updateLastUsedTime();
                    if (QueryHandler.this.killed) {
                        throw new Exception("Query [" + QueryHandler.this.identifier + "] has been killed");
                    }
                    QueryHandler.this.info("Process count request [limit=" + limit + "]");
                    ResultCount resultCount = QueryHandler.this.hiveController.countResults(limit);
                    return resultCount;
                }
                finally {
                    QueryHandler.this.updateLastUsedTime();
                    QueryHandler.this.setFetchFlag(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized QueryStatus.HiveQueryState getState() {
        Object object = this.stateWait;
        synchronized (object) {
            return this.state;
        }
    }

    private synchronized void killHiveInParallel() {
        this.info("Hive is executing a query, we have to kill it in parallel");
        if (this.hiveController == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    QueryHandler.this.hiveController.kill();
                    QueryHandler.this.hiveController = null;
                    QueryHandler.this.session.getHiveThread().patientShutdownNow(QueryHandler.this.identifier);
                }
                catch (InterruptedException e) {
                    QueryHandler.this.info("Interruption occurred when trying to kill the query", e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    QueryHandler.this.info("Error occurred when trying to kill the query", e);
                }
            }
        };
        t.start();
    }

    private synchronized void killHiveGracefully() {
        this.info("Hive is not executing a query, we can kill it nicely");
        this.session.getHiveThread().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryHandler.this.info("Kill Hive now");
                if (QueryHandler.this.hiveController != null) {
                    QueryHandler.this.info("Kill Hive now");
                    QueryHandler.this.hiveController.kill();
                    QueryHandler.this.hiveController = null;
                }
                return null;
            }
        });
    }

    @Override
    public synchronized void kill() {
        assert (!this.killed);
        this.info("Received kill request !");
        this.killed = true;
        try {
            if (this.state == QueryStatus.HiveQueryState.EXECUTING_QUERY) {
                this.killHiveInParallel();
            } else {
                this.killHiveGracefully();
            }
            if (this.releaseSession()) {
                this.info("still using the session, destroying it");
                this.session.destroy();
            } else {
                this.info("not using the session anymore, just unregistering");
                this.session.deregisterUsage(this);
            }
        }
        finally {
            this.setState(QueryStatus.HiveQueryState.DEAD);
        }
    }

    @Override
    public synchronized void release() {
        this.session.getHiveThread().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (QueryHandler.this.hiveController != null) {
                    QueryHandler.this.hiveController.release();
                }
                return null;
            }
        });
    }

    @Override
    public synchronized String getLogTail() {
        if (this.hiveController == null) {
            return "";
        }
        return this.hiveController.getLogTail();
    }

    @Override
    public synchronized void injectLogMessage(String msg) {
        if (this.hiveController != null) {
            this.hiveController.injectLogMessage(msg);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

