/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.server.hive.executor.IHiveLoader;
import com.dataiku.hproxy.server.hive.executor.IHiveSession;
import com.dataiku.hproxy.server.hive.executor.SeparateClassLoaderExecutor;
import com.dataiku.hproxy.server.hive.executor.SessionHandler;
import com.dataiku.hproxy.utils.Reflector;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SessionHandlerPool {
    private final List<SessionHandler> sessionHandlers = Lists.newArrayList();
    private final Map<Set<String>, List<SessionHandler>> availableSessionHandlers = Maps.newHashMap();
    private final SeparateClassLoaderExecutor classLoaderExecutor;
    private final IHiveLoader hiveLoader;
    private Pattern addJarPattern = Pattern.compile("^\\s*add\\s+jar\\s+(.*)\\s*(;\\s*)?$", 2);
    private static Logger logger = Logger.getLogger(SessionHandlerPool.class);

    public SessionHandlerPool(IHiveLoader hiveLoader, SeparateClassLoaderExecutor classLoaderExecutor) {
        this.hiveLoader = hiveLoader;
        this.classLoaderExecutor = classLoaderExecutor;
    }

    public synchronized SessionHandler take(String[] initQueries) throws Exception {
        Set<String> addedJars = this.buildAddedJarSet(initQueries);
        List<SessionHandler> availableSessionHandlersForJars = this.availableSessionHandlers.get(addedJars);
        if (availableSessionHandlersForJars != null && availableSessionHandlersForJars.size() > 0) {
            return availableSessionHandlersForJars.remove(0);
        }
        return this.create(addedJars);
    }

    private Set<String> buildAddedJarSet(String[] initQueries) {
        HashSet jars = Sets.newHashSet();
        for (String q : initQueries) {
            Matcher addJarMatcher = this.addJarPattern.matcher(q);
            if (!addJarMatcher.matches()) continue;
            jars.addAll(Arrays.asList(addJarMatcher.group(1).split("\\s+")));
        }
        return jars;
    }

    public synchronized void give(SessionHandler handler) {
        ArrayList availableSessionHandlersForJars = this.availableSessionHandlers.get(handler.getAddedJars());
        if (availableSessionHandlersForJars == null) {
            availableSessionHandlersForJars = Lists.newArrayList();
            this.availableSessionHandlers.put(handler.getAddedJars(), availableSessionHandlersForJars);
        }
        availableSessionHandlersForJars.add(handler);
    }

    public synchronized void dispose(SessionHandler handler) {
        List<SessionHandler> availableSessionHandlersForJars = this.availableSessionHandlers.get(handler.getAddedJars());
        if (availableSessionHandlersForJars != null && availableSessionHandlersForJars.remove(handler)) {
            handler.destroy();
        } else {
            logger.info((Object)"Could not dispose session");
        }
    }

    public synchronized void forget(SessionHandler handler) {
        if (this.sessionHandlers.remove(handler)) {
            List<SessionHandler> availableSessionHandlersForJars = this.availableSessionHandlers.get(handler.getAddedJars());
            if (availableSessionHandlersForJars != null) {
                availableSessionHandlersForJars.remove(handler);
            }
        } else {
            logger.info((Object)"Could not forget session");
        }
    }

    private SessionHandler create(Set<String> addedJars) throws Exception {
        try {
            IHiveSession hiveSession = this.classLoaderExecutor.runFully(new Callable<IHiveSession>(){

                @Override
                public IHiveSession call() throws Exception {
                    return (IHiveSession)new Reflector(SessionHandlerPool.this.classLoaderExecutor.getClassLoader()).newInstance("com.dataiku.hproxy.sandbox.hive.common.HiveSessionImpl", new Object[]{SessionHandlerPool.this.hiveLoader});
                }
            });
            SessionHandler handler = new SessionHandler(addedJars, hiveSession, this, this.classLoaderExecutor);
            this.sessionHandlers.add(handler);
            return handler;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create hive session", (Throwable)e);
            throw new Exception("Unable to create hive session");
        }
    }

    synchronized ExecutionResults listHandlers() {
        ExecutionResults ret = new ExecutionResults();
        ret.columns.add(new ColumnSchema().withName("identifier").withType("string"));
        ret.columns.add(new ColumnSchema().withName("sessionActive").withType("boolean"));
        ret.columns.add(new ColumnSchema().withName("threadActive").withType("boolean"));
        ret.columns.add(new ColumnSchema().withName("used").withType("boolean"));
        ret.columns.add(new ColumnSchema().withName("queryRegistered").withType("int"));
        ArrayList allAvailable = Lists.newArrayList();
        for (Map.Entry<Set<String>, List<SessionHandler>> e : this.availableSessionHandlers.entrySet()) {
            allAvailable.addAll((Collection)e.getValue());
        }
        for (SessionHandler handler : this.sessionHandlers) {
            ArrayList row = Lists.newArrayList();
            row.add(handler.getSession().getIdentifier());
            row.add(String.valueOf(handler.getSession().isActive()));
            row.add(String.valueOf(!handler.getHiveThread().isShutdown()));
            row.add(String.valueOf(!allAvailable.contains(handler)));
            row.add(String.valueOf(handler.getRegisteredCount()));
            ret.rows.add(row.toArray(new String[0]));
        }
        return ret;
    }

    public SessionHandler getHandler(String id) {
        for (SessionHandler sessionHandler : this.sessionHandlers) {
            if (!sessionHandler.getSession().getIdentifier().equals(id)) continue;
            return sessionHandler;
        }
        return null;
    }
}

