/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.lambda.mgmt.IPackagesMgmtService;
import com.dataiku.dip.lambda.mgmt.ServicePackager;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackagesMgmtServiceImpl
implements IPackagesMgmtService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private PubSubService messagingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.packager");

    public static FuturePayload buildFuturePayload(LambdaService srcConfig) {
        FuturePayload fp = new FuturePayload();
        fp.action = "create_lambda_package";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(srcConfig.projectKey, srcConfig.id, srcConfig.id, ITaggingService.TaggableType.LAMBDA_SERVICE.name()));
        fp.displayName = "Generating DS\u039b package";
        return fp;
    }

    @Override
    public FutureResponse<InfoMessage.InfoMessages> startGeneratingPackage(File destdir, String projectKey, LambdaService config, List<SerializedProject.PermissionItem> permissions, AuthCtx liu, boolean forDev) throws Exception {
        assert (destdir.isDirectory());
        ServicePackager sp = new ServicePackager(liu, projectKey, config, permissions, destdir, forDev);
        sp.init();
        GenerationTask gt = new GenerationTask((DSSAuthCtx)liu, sp, destdir);
        return this.futureService.runFuture((FutureThreadBase)gt, 1L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    class GenerationTask
    extends FutureThread<InfoMessage.InfoMessages> {
        ServicePackager packager;
        File destdir;
        InfoMessage.InfoMessages done;
        private final FuturePayload futurePayload;

        public GenerationTask(DSSAuthCtx login, ServicePackager packager, File destdir) {
            super(login);
            this.done = null;
            this.packager = packager;
            this.destdir = destdir;
            this.futurePayload = PackagesMgmtServiceImpl.buildFuturePayload(packager.srcConfig);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InfoMessage.InfoMessages getResult() {
            return this.done;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            this.packager.build_NT(ret);
            JsonObject details = new JsonObject();
            details.addProperty("packageId", this.destdir.getName());
            details.addProperty("location", this.destdir.getAbsolutePath());
            JsonArray endpoints = new JsonArray();
            for (DSSLambdaEndpointConfig ep : ServicePackager.deDuplicateEndpointNames(this.packager.srcConfig.endpoints)) {
                JsonObject epo = new JsonObject();
                epo.addProperty("id", ep.id);
                epo.addProperty("type", ep.type.name());
                endpoints.add((JsonElement)epo);
            }
            details.add("endpoints", (JsonElement)endpoints);
            String projectKey = this.packager.srcConfig.projectKey;
            PackagesMgmtServiceImpl.this.messagingService.publish(new TaggableObjectChangedEvent(ITaggingService.TaggableType.LAMBDA_SERVICE, projectKey, this.packager.srcConfig.id, (AuthCtx)this.getOwner(), TaggableObjectChangedEvent.ActionType.LAMBDA_SERVICE_PACKAGE).withDetails(details));
            this.done = ret;
        }

        public void postRunCleanup() {
            if (this.aborted || this.done == null) {
                try {
                    DKUFileUtils.delete((File)this.destdir);
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
    }
}

