/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JF;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projectsFromBundle"})
public class PublicAPIBundlesImportController
extends PublicAPIControllerBase {
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void createFromStream(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart, @RequestParam(required=false) String projectFolderId, @RequestParam(required=false) String projectKey, @RequestParam(required=false, defaultValue="NONE") AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws Exception {
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        String newProjectKey = this.automationBundlesService.createProjectUsingInitialBundleZipStream((AuthCtx)authCtx, filePart.getInputStream(), projectFolderId, projectKey, permissionsPropagationPolicy);
        PublicAPIBundlesImportController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("projectKey", newProjectKey).get());
        this.auditTrailService.generic("automation-project-create").with("fileName", filePart.getOriginalFilename()).with("projectKey", newProjectKey).with("permissionsPropagationPolicy", permissionsPropagationPolicy.toString()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/fromArchive"}, method={RequestMethod.POST})
    public void createFromArchive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String archivePath, @RequestParam(required=false) String projectFolderId, @RequestParam(required=false) String projectKey, @RequestParam(required=false, defaultValue="NONE") AbstractProjectDeploymentInfra.PermissionsPropagationPolicy permissionsPropagationPolicy) throws Exception {
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
        }
        String newProjectKey = this.automationBundlesService.createProjectUsingInitialBundleArchive((AuthCtx)authCtx, new File(archivePath), true, projectFolderId, projectKey, permissionsPropagationPolicy);
        PublicAPIBundlesImportController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("projectKey", newProjectKey).get());
        this.auditTrailService.generic("automation-project-create").with("archiveFilePath", archivePath).with("projectKey", newProjectKey).with("permissionsPropagationPolicy", permissionsPropagationPolicy.toString()).emit();
    }
}

