/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugin;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.partitioning.Partition;
import java.io.InputStream;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;

public class InputStreamWithContextInfo {
    private final Partition partition;
    private final InputStream is;
    private final String fileName;
    private final String pathWithinProvider;
    @Nonnull
    private final LongSupplier lastModifiedSupplier;

    public InputStreamWithContextInfo(InputStream is, String pathWithinProvider, String fileName, Partition partition, final @Nonnull LongSupplier lastModifiedSupplier) {
        this.is = is;
        this.fileName = fileName;
        this.pathWithinProvider = pathWithinProvider;
        this.partition = partition;
        this.lastModifiedSupplier = new LongSupplier(){
            Long lastModified;

            @Override
            public long getAsLong() {
                if (this.lastModified == null) {
                    this.lastModified = lastModifiedSupplier.getAsLong();
                }
                return this.lastModified;
            }
        };
    }

    public void fillRowContext(Row.RowContext rc) {
        rc.sourcePartition = this.getPartition();
        rc.sourceFilepath = this.getPathWithinProvider();
        rc.sourceFilename = this.getFilename();
        rc.sourceLastModifiedSupplier = this.getLastModifiedSupplier();
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getPathWithinProvider() {
        return this.pathWithinProvider;
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Nonnull
    public LongSupplier getLastModifiedSupplier() {
        return this.lastModifiedSupplier;
    }
}

