/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.scoring.models.DecisionTreeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DecisionTreeModelBuilder<T> {
    private final long[] nodeIds;
    private final int[] features;
    private final double[] thresholds;
    private final String[] missing;
    private final long[] leafIds;
    private final T[] labels;

    public DecisionTreeModelBuilder(long[] nodeIds, int[] features, double[] thresholds, String[] missing, long[] leafIds, T[] labels) {
        this.nodeIds = nodeIds;
        this.features = features;
        this.thresholds = thresholds;
        this.missing = missing;
        this.leafIds = leafIds;
        this.labels = labels;
    }

    public DecisionTreeModel.Node<T> buildTree() {
        HashMap<Long, Integer> nodeIdIndex = new HashMap<Long, Integer>();
        for (int i = 0; i < this.nodeIds.length; ++i) {
            nodeIdIndex.put(this.nodeIds[i], i);
        }
        TreeMap nodes = new TreeMap();
        for (int i = 0; i < this.leafIds.length; ++i) {
            DecisionTreeModel.Node<T> leaf = DecisionTreeModel.Node.leaf(this.leafIds[i], this.labels[i]);
            nodes.put(this.leafIds[i], leaf);
        }
        while (nodes.size() != 1) {
            Map.Entry e = nodes.lastEntry();
            DecisionTreeModel.Node toMerge = (DecisionTreeModel.Node)e.getValue();
            long index = (Long)e.getKey();
            long brotherIndex = index % 2L == 0L ? index - 1L : index + 1L;
            DecisionTreeModel.Node brother = (DecisionTreeModel.Node)nodes.get(brotherIndex);
            DecisionTreeModel.Node left = index % 2L == 0L ? brother : toMerge;
            DecisionTreeModel.Node right = left == brother ? toMerge : brother;
            long fatherIndex = (index - 1L) / 2L;
            int fatherArrayIndex = (Integer)nodeIdIndex.get(fatherIndex);
            Boolean missingGoesLeft = null;
            if (this.missing != null && this.missing.length > 0) {
                if (this.missing[fatherArrayIndex].equals("l")) {
                    missingGoesLeft = true;
                } else if (this.missing[fatherArrayIndex].equals("r")) {
                    missingGoesLeft = false;
                } else {
                    throw new RuntimeException("Unknown missing value: " + this.missing[fatherArrayIndex]);
                }
            }
            DecisionTreeModel.Node node = DecisionTreeModel.Node.node(fatherIndex, this.features[fatherArrayIndex], this.thresholds[fatherArrayIndex], left, right, missingGoesLeft);
            nodes.put(fatherIndex, node);
            nodes.remove(index);
            nodes.remove(brotherIndex);
        }
        return (DecisionTreeModel.Node)nodes.get(0L);
    }
}

