/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models.overrides;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class MLOverridesParamsBase<T>
implements Serializable {
    public List<MLOverride<T>> overrides = new ArrayList<MLOverride<T>>();

    protected MLOverridesParamsBase() {
    }

    public boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    public static class MLOverride<T>
    implements Serializable {
        public String name = "Override";
        public T filter;
        public Outcome outcome;

        public String toString() {
            return "MLOverride(" + this.name + ")";
        }

        public static class Outcome
        implements Serializable {
            public Type type;
            public String category;
            public Double minValue;
            public Double maxValue;

            public String toString() {
                switch (this.type) {
                    case INTERVAL: {
                        return "[" + this.minValue + ", " + this.maxValue + "]";
                    }
                    case CATEGORY: {
                        return this.category;
                    }
                    case DECLINED: {
                        return "Declined";
                    }
                }
                throw new IllegalArgumentException("Unreachable");
            }

            public static enum Type {
                INTERVAL,
                CATEGORY,
                DECLINED;

            }
        }
    }
}

