/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractLongMeaning;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;

public class AnyTemporal
extends AbstractLongMeaning {
    Date date = new Date();
    DateOnly dateOnly = new DateOnly();
    DatetimeNoTz datetimeNoTz = new DatetimeNoTz();

    @Override
    public String getMeaningId() {
        return "AnyTemporal";
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    @Override
    public long longValue(String val) {
        long ts = this.date.longValue(val);
        if (ts == Long.MAX_VALUE) {
            ts = this.dateOnly.longValue(val);
        }
        if (ts == Long.MAX_VALUE) {
            ts = this.datetimeNoTz.longValue(val);
        }
        return ts;
    }

    @Override
    public double detects(String val) {
        return Math.max(this.date.detects(val), Math.max(this.dateOnly.detects(val), this.datetimeNoTz.detects(val)));
    }

    public long msSinceEpoch(String v) {
        long ts = this.date.msSinceEpoch(v);
        if (ts == Long.MAX_VALUE) {
            ts = this.dateOnly.msSinceEpoch(v);
        }
        if (ts == Long.MAX_VALUE) {
            ts = this.datetimeNoTz.msSinceEpoch(v);
        }
        return ts;
    }
}

