/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Adler32;

@SdkInternalApi
public class UpdateExpressionGenerator {
    private String generateSubstitutionTokenString(String baseToken, Long suffixCounter, Set<String> expressionAttributeNamesKeys, Set<String> expressionAttributeValuesKeys) {
        String hexSuffix = Long.toHexString(suffixCounter);
        String tokenBase = baseToken.substring(0, Math.min(baseToken.length(), 4)) + hexSuffix;
        if (!expressionAttributeNamesKeys.contains(UpdateExpressionGenerator.getExpressionAttributeNameSubstitutionToken(tokenBase)) && !expressionAttributeValuesKeys.contains(UpdateExpressionGenerator.getExpressionAttributeValueSubstitutionToken(tokenBase))) {
            return tokenBase;
        }
        String fullToken = baseToken + hexSuffix;
        if (!expressionAttributeNamesKeys.contains(UpdateExpressionGenerator.getExpressionAttributeNameSubstitutionToken(fullToken)) && !expressionAttributeValuesKeys.contains(UpdateExpressionGenerator.getExpressionAttributeValueSubstitutionToken(fullToken))) {
            return fullToken;
        }
        throw new DynamoDBMappingException("Failed to process update operation inside transactionWrite request due to conflict with expressionAttributeName or expressionAttributeValue token name: " + fullToken + ". Please replace this token name with a different token name.");
    }

    private String generateSubstitutionTokenString(String baseToken, Long suffixCounter, Set<String> expressionAttributeNamesKeys) {
        return this.generateSubstitutionTokenString(baseToken, suffixCounter, expressionAttributeNamesKeys, Collections.emptySet());
    }

    public String generateUpdateExpressionAndUpdateAttributeMaps(Map<String, String> expressionAttributeNamesMap, Map<String, AttributeValue> expressionsAttributeValuesMap, Map<String, AttributeValue> nonKeyNonNullAttributeValueMap, List<String> nullValuedNonKeyAttributeNames) {
        Object tokenKeyName;
        Long l;
        StringBuilder updateExpressionSetBuilder = new StringBuilder();
        StringBuilder updateExpressionDeleteBuilder = new StringBuilder();
        ArrayList<String> sortedNonKeyNonNullAttributeNames = new ArrayList<String>(nonKeyNonNullAttributeValueMap.keySet());
        Collections.sort(sortedNonKeyNonNullAttributeNames);
        ArrayList<String> sortedNullValuedNonKeyAttributeNames = new ArrayList<String>(nullValuedNonKeyAttributeNames);
        Collections.sort(sortedNullValuedNonKeyAttributeNames);
        String baseToken = this.getBaseToken(sortedNonKeyNonNullAttributeNames, sortedNullValuedNonKeyAttributeNames);
        Long suffixCounter = 0L;
        if (sortedNonKeyNonNullAttributeNames.size() > 0) {
            updateExpressionSetBuilder.append("SET ");
            ArrayList<String> updateStringSetExpressions = new ArrayList<String>();
            for (String nonKeyAttributeName : sortedNonKeyNonNullAttributeNames) {
                String tokenBase = this.generateSubstitutionTokenString(baseToken, suffixCounter, expressionAttributeNamesMap.keySet(), expressionsAttributeValuesMap.keySet());
                Long l2 = suffixCounter;
                l = suffixCounter = Long.valueOf(suffixCounter + 1L);
                tokenKeyName = UpdateExpressionGenerator.getExpressionAttributeNameSubstitutionToken(tokenBase);
                String tokenValueName = UpdateExpressionGenerator.getExpressionAttributeValueSubstitutionToken(tokenBase);
                expressionAttributeNamesMap.put((String)tokenKeyName, nonKeyAttributeName);
                expressionsAttributeValuesMap.put(tokenValueName, nonKeyNonNullAttributeValueMap.get(nonKeyAttributeName));
                updateStringSetExpressions.add((String)tokenKeyName + " = " + tokenValueName);
            }
            for (int i = 0; i < updateStringSetExpressions.size() - 1; ++i) {
                updateExpressionSetBuilder.append((String)updateStringSetExpressions.get(i) + ", ");
            }
            updateExpressionSetBuilder.append((String)updateStringSetExpressions.get(updateStringSetExpressions.size() - 1));
        }
        if (sortedNullValuedNonKeyAttributeNames.size() > 0) {
            updateExpressionDeleteBuilder.append("REMOVE ");
            ArrayList<Object> updateStringDeleteExpressions = new ArrayList<Object>();
            for (String nullAttributeName : sortedNullValuedNonKeyAttributeNames) {
                String tokenBaseString = this.generateSubstitutionTokenString(baseToken, suffixCounter, expressionAttributeNamesMap.keySet());
                tokenKeyName = suffixCounter;
                l = suffixCounter = Long.valueOf(suffixCounter + 1L);
                tokenKeyName = UpdateExpressionGenerator.getExpressionAttributeNameSubstitutionToken(tokenBaseString);
                expressionAttributeNamesMap.put((String)tokenKeyName, nullAttributeName);
                updateStringDeleteExpressions.add(tokenKeyName);
            }
            for (int i = 0; i < updateStringDeleteExpressions.size() - 1; ++i) {
                updateExpressionDeleteBuilder.append((String)updateStringDeleteExpressions.get(i) + ", ");
            }
            updateExpressionDeleteBuilder.append((String)updateStringDeleteExpressions.get(updateStringDeleteExpressions.size() - 1));
        }
        StringBuilder updateExpression = new StringBuilder();
        if (updateExpressionSetBuilder.length() > 0) {
            updateExpression.append(updateExpressionSetBuilder.toString());
        }
        if (updateExpressionDeleteBuilder.length() > 0) {
            updateExpression.append(" " + updateExpressionDeleteBuilder.toString());
        }
        return updateExpression.toString();
    }

    private static String getExpressionAttributeNameSubstitutionToken(String tokenBase) {
        return "#" + tokenBase;
    }

    private static String getExpressionAttributeValueSubstitutionToken(String tokenBase) {
        return ":" + tokenBase;
    }

    private String getBaseToken(List<String> sortedNonKeyNonNullAttributeNames, List<String> sortedNullValuedNonKeyAttributeNames) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (String nonKeyNonNullAttributeName : sortedNonKeyNonNullAttributeNames) {
                dataOutputStream.writeUTF(nonKeyNonNullAttributeName);
            }
            for (String nullValuedNonKeyAttributeName : sortedNullValuedNonKeyAttributeNames) {
                dataOutputStream.writeUTF(nullValuedNonKeyAttributeName);
            }
        }
        catch (IOException e) {
            throw new DynamoDBMappingException("Failed to process update operation inside transactionWrite request due to an IOException ", e);
        }
        Adler32 adler32 = new Adler32();
        adler32.update(byteArrayOutputStream.toByteArray());
        return Long.toHexString(adler32.getValue());
    }
}

