/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonServiceException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathExpression;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathField;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.JmesPathSubExpression;
import com.dataiku.dss.legacy.aws.com.amazonaws.jmespath.ObjectMapperSingleton;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.AcceptorPathMatcher;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterAcceptor;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterState;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class TableExists {
    TableExists() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeTableResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsACTIVEMatcher() {
        }

        @Override
        public boolean matches(DescribeTableResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("Table"), new JmesPathField("TableStatus"));
        }
    }
}

