/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateNatGatewayRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    @Override
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        SdkInternalList createNatGatewayRequestSecondaryPrivateIpAddressesList;
        SdkInternalList createNatGatewayRequestSecondaryAllocationIdsList;
        SdkInternalList createNatGatewayRequestTagSpecificationsList;
        if (createNatGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNatGatewayRequest> request = new DefaultRequest<CreateNatGatewayRequest>(createNatGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString(createNatGatewayRequest.getAllocationId()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createNatGatewayRequest.getClientToken()));
        if (createNatGatewayRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(createNatGatewayRequest.getSubnetId()));
        }
        if (!(createNatGatewayRequestTagSpecificationsList = (SdkInternalList)createNatGatewayRequest.getTagSpecifications()).isEmpty() || !createNatGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (Object createNatGatewayRequestTagSpecificationsListValue : createNatGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createNatGatewayRequest.getConnectivityType() != null) {
            request.addParameter("ConnectivityType", StringUtils.fromString(createNatGatewayRequest.getConnectivityType()));
        }
        if (createNatGatewayRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(createNatGatewayRequest.getPrivateIpAddress()));
        }
        if (!(createNatGatewayRequestSecondaryAllocationIdsList = (SdkInternalList)createNatGatewayRequest.getSecondaryAllocationIds()).isEmpty() || !createNatGatewayRequestSecondaryAllocationIdsList.isAutoConstruct()) {
            int secondaryAllocationIdsListIndex = 1;
            for (String createNatGatewayRequestSecondaryAllocationIdsListValue : createNatGatewayRequestSecondaryAllocationIdsList) {
                if (createNatGatewayRequestSecondaryAllocationIdsListValue != null) {
                    request.addParameter("SecondaryAllocationId." + secondaryAllocationIdsListIndex, StringUtils.fromString(createNatGatewayRequestSecondaryAllocationIdsListValue));
                }
                ++secondaryAllocationIdsListIndex;
            }
        }
        if (!(createNatGatewayRequestSecondaryPrivateIpAddressesList = (SdkInternalList)createNatGatewayRequest.getSecondaryPrivateIpAddresses()).isEmpty() || !createNatGatewayRequestSecondaryPrivateIpAddressesList.isAutoConstruct()) {
            int secondaryPrivateIpAddressesListIndex = 1;
            for (String createNatGatewayRequestSecondaryPrivateIpAddressesListValue : createNatGatewayRequestSecondaryPrivateIpAddressesList) {
                if (createNatGatewayRequestSecondaryPrivateIpAddressesListValue != null) {
                    request.addParameter("SecondaryPrivateIpAddress." + secondaryPrivateIpAddressesListIndex, StringUtils.fromString(createNatGatewayRequestSecondaryPrivateIpAddressesListValue));
                }
                ++secondaryPrivateIpAddressesListIndex;
            }
        }
        if (createNatGatewayRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger(createNatGatewayRequest.getSecondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

