/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DisassociateInstanceEventWindowRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.InstanceEventWindowDisassociationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DisassociateInstanceEventWindowRequestMarshaller
implements Marshaller<Request<DisassociateInstanceEventWindowRequest>, DisassociateInstanceEventWindowRequest> {
    @Override
    public Request<DisassociateInstanceEventWindowRequest> marshall(DisassociateInstanceEventWindowRequest disassociateInstanceEventWindowRequest) {
        InstanceEventWindowDisassociationRequest associationTarget;
        if (disassociateInstanceEventWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisassociateInstanceEventWindowRequest> request = new DefaultRequest<DisassociateInstanceEventWindowRequest>(disassociateInstanceEventWindowRequest, "AmazonEC2");
        request.addParameter("Action", "DisassociateInstanceEventWindow");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (disassociateInstanceEventWindowRequest.getInstanceEventWindowId() != null) {
            request.addParameter("InstanceEventWindowId", StringUtils.fromString(disassociateInstanceEventWindowRequest.getInstanceEventWindowId()));
        }
        if ((associationTarget = disassociateInstanceEventWindowRequest.getAssociationTarget()) != null) {
            SdkInternalList instanceEventWindowDisassociationRequestDedicatedHostIdsList;
            SdkInternalList instanceEventWindowDisassociationRequestInstanceTagsList;
            SdkInternalList instanceEventWindowDisassociationRequestInstanceIdsList = (SdkInternalList)associationTarget.getInstanceIds();
            if (!instanceEventWindowDisassociationRequestInstanceIdsList.isEmpty() || !instanceEventWindowDisassociationRequestInstanceIdsList.isAutoConstruct()) {
                int instanceIdsListIndex = 1;
                for (Object instanceEventWindowDisassociationRequestInstanceIdsListValue : instanceEventWindowDisassociationRequestInstanceIdsList) {
                    if (instanceEventWindowDisassociationRequestInstanceIdsListValue != null) {
                        request.addParameter("AssociationTarget.InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)instanceEventWindowDisassociationRequestInstanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            }
            if (!(instanceEventWindowDisassociationRequestInstanceTagsList = (SdkInternalList)associationTarget.getInstanceTags()).isEmpty() || !instanceEventWindowDisassociationRequestInstanceTagsList.isAutoConstruct()) {
                int instanceTagsListIndex = 1;
                for (Tag instanceEventWindowDisassociationRequestInstanceTagsListValue : instanceEventWindowDisassociationRequestInstanceTagsList) {
                    if (instanceEventWindowDisassociationRequestInstanceTagsListValue.getKey() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Key", StringUtils.fromString(instanceEventWindowDisassociationRequestInstanceTagsListValue.getKey()));
                    }
                    if (instanceEventWindowDisassociationRequestInstanceTagsListValue.getValue() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Value", StringUtils.fromString(instanceEventWindowDisassociationRequestInstanceTagsListValue.getValue()));
                    }
                    ++instanceTagsListIndex;
                }
            }
            if (!(instanceEventWindowDisassociationRequestDedicatedHostIdsList = (SdkInternalList)associationTarget.getDedicatedHostIds()).isEmpty() || !instanceEventWindowDisassociationRequestDedicatedHostIdsList.isAutoConstruct()) {
                int dedicatedHostIdsListIndex = 1;
                for (String instanceEventWindowDisassociationRequestDedicatedHostIdsListValue : instanceEventWindowDisassociationRequestDedicatedHostIdsList) {
                    if (instanceEventWindowDisassociationRequestDedicatedHostIdsListValue != null) {
                        request.addParameter("AssociationTarget.DedicatedHostId." + dedicatedHostIdsListIndex, StringUtils.fromString(instanceEventWindowDisassociationRequestDedicatedHostIdsListValue));
                    }
                    ++dedicatedHostIdsListIndex;
                }
            }
        }
        return request;
    }
}

