/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.ForwardActionConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.RedirectActionConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupTuple;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    @Override
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        if (createListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateListenerRequest> request = new DefaultRequest<CreateListenerRequest>(createListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString(createListenerRequest.getLoadBalancerArn()));
        }
        if (createListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(createListenerRequest.getProtocol()));
        }
        if (createListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(createListenerRequest.getPort()));
        }
        if (createListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString(createListenerRequest.getSslPolicy()));
        }
        if (createListenerRequest.getCertificates() != null) {
            List<Certificate> certificatesList = createListenerRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue != null) {
                        if (certificatesListValue.getCertificateArn() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString(certificatesListValue.getCertificateArn()));
                        }
                        if (certificatesListValue.getIsDefault() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean(certificatesListValue.getIsDefault()));
                        }
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if (createListenerRequest.getDefaultActions() != null) {
            List<Action> defaultActionsList = createListenerRequest.getDefaultActions();
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue != null) {
                        ForwardActionConfig forwardConfig;
                        FixedResponseActionConfig fixedResponseConfig;
                        RedirectActionConfig redirectConfig;
                        AuthenticateCognitoActionConfig authenticateCognitoConfig;
                        int authenticationRequestExtraParamsListIndex;
                        Map<String, String> authenticationRequestExtraParams;
                        AuthenticateOidcActionConfig authenticateOidcConfig;
                        if (defaultActionsListValue.getType() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString(defaultActionsListValue.getType()));
                        }
                        if (defaultActionsListValue.getTargetGroupArn() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString(defaultActionsListValue.getTargetGroupArn()));
                        }
                        if ((authenticateOidcConfig = defaultActionsListValue.getAuthenticateOidcConfig()) != null) {
                            if (authenticateOidcConfig.getIssuer() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Issuer", StringUtils.fromString(authenticateOidcConfig.getIssuer()));
                            }
                            if (authenticateOidcConfig.getAuthorizationEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringUtils.fromString(authenticateOidcConfig.getAuthorizationEndpoint()));
                            }
                            if (authenticateOidcConfig.getTokenEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringUtils.fromString(authenticateOidcConfig.getTokenEndpoint()));
                            }
                            if (authenticateOidcConfig.getUserInfoEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringUtils.fromString(authenticateOidcConfig.getUserInfoEndpoint()));
                            }
                            if (authenticateOidcConfig.getClientId() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientId", StringUtils.fromString(authenticateOidcConfig.getClientId()));
                            }
                            if (authenticateOidcConfig.getClientSecret() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringUtils.fromString(authenticateOidcConfig.getClientSecret()));
                            }
                            if (authenticateOidcConfig.getSessionCookieName() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringUtils.fromString(authenticateOidcConfig.getSessionCookieName()));
                            }
                            if (authenticateOidcConfig.getScope() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Scope", StringUtils.fromString(authenticateOidcConfig.getScope()));
                            }
                            if (authenticateOidcConfig.getSessionTimeout() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringUtils.fromLong(authenticateOidcConfig.getSessionTimeout()));
                            }
                            if ((authenticationRequestExtraParams = authenticateOidcConfig.getAuthenticationRequestExtraParams()) != null) {
                                authenticationRequestExtraParamsListIndex = 1;
                                for (Map.Entry entry : authenticationRequestExtraParams.entrySet()) {
                                    if (entry != null && entry.getKey() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                    }
                                    if (entry != null && entry.getValue() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                    }
                                    ++authenticationRequestExtraParamsListIndex;
                                }
                            }
                            if (authenticateOidcConfig.getOnUnauthenticatedRequest() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringUtils.fromString(authenticateOidcConfig.getOnUnauthenticatedRequest()));
                            }
                            if (authenticateOidcConfig.getUseExistingClientSecret() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UseExistingClientSecret", StringUtils.fromBoolean(authenticateOidcConfig.getUseExistingClientSecret()));
                            }
                        }
                        if ((authenticateCognitoConfig = defaultActionsListValue.getAuthenticateCognitoConfig()) != null) {
                            if (authenticateCognitoConfig.getUserPoolArn() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringUtils.fromString(authenticateCognitoConfig.getUserPoolArn()));
                            }
                            if (authenticateCognitoConfig.getUserPoolClientId() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringUtils.fromString(authenticateCognitoConfig.getUserPoolClientId()));
                            }
                            if (authenticateCognitoConfig.getUserPoolDomain() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringUtils.fromString(authenticateCognitoConfig.getUserPoolDomain()));
                            }
                            if (authenticateCognitoConfig.getSessionCookieName() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringUtils.fromString(authenticateCognitoConfig.getSessionCookieName()));
                            }
                            if (authenticateCognitoConfig.getScope() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.Scope", StringUtils.fromString(authenticateCognitoConfig.getScope()));
                            }
                            if (authenticateCognitoConfig.getSessionTimeout() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringUtils.fromLong(authenticateCognitoConfig.getSessionTimeout()));
                            }
                            if ((authenticationRequestExtraParams = authenticateCognitoConfig.getAuthenticationRequestExtraParams()) != null) {
                                authenticationRequestExtraParamsListIndex = 1;
                                for (Map.Entry entry : authenticationRequestExtraParams.entrySet()) {
                                    if (entry != null && entry.getKey() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                    }
                                    if (entry != null && entry.getValue() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                    }
                                    ++authenticationRequestExtraParamsListIndex;
                                }
                            }
                            if (authenticateCognitoConfig.getOnUnauthenticatedRequest() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringUtils.fromString(authenticateCognitoConfig.getOnUnauthenticatedRequest()));
                            }
                        }
                        if (defaultActionsListValue.getOrder() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Order", StringUtils.fromInteger(defaultActionsListValue.getOrder()));
                        }
                        if ((redirectConfig = defaultActionsListValue.getRedirectConfig()) != null) {
                            if (redirectConfig.getProtocol() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Protocol", StringUtils.fromString(redirectConfig.getProtocol()));
                            }
                            if (redirectConfig.getPort() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Port", StringUtils.fromString(redirectConfig.getPort()));
                            }
                            if (redirectConfig.getHost() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Host", StringUtils.fromString(redirectConfig.getHost()));
                            }
                            if (redirectConfig.getPath() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Path", StringUtils.fromString(redirectConfig.getPath()));
                            }
                            if (redirectConfig.getQuery() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Query", StringUtils.fromString(redirectConfig.getQuery()));
                            }
                            if (redirectConfig.getStatusCode() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.StatusCode", StringUtils.fromString(redirectConfig.getStatusCode()));
                            }
                        }
                        if ((fixedResponseConfig = defaultActionsListValue.getFixedResponseConfig()) != null) {
                            if (fixedResponseConfig.getMessageBody() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.MessageBody", StringUtils.fromString(fixedResponseConfig.getMessageBody()));
                            }
                            if (fixedResponseConfig.getStatusCode() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.StatusCode", StringUtils.fromString(fixedResponseConfig.getStatusCode()));
                            }
                            if (fixedResponseConfig.getContentType() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.ContentType", StringUtils.fromString(fixedResponseConfig.getContentType()));
                            }
                        }
                        if ((forwardConfig = defaultActionsListValue.getForwardConfig()) != null) {
                            TargetGroupStickinessConfig targetGroupStickinessConfig;
                            if (forwardConfig.getTargetGroups() != null) {
                                List<TargetGroupTuple> targetGroupsList = forwardConfig.getTargetGroups();
                                if (targetGroupsList.isEmpty()) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups", "");
                                } else {
                                    int targetGroupsListIndex = 1;
                                    for (TargetGroupTuple targetGroupTuple : targetGroupsList) {
                                        if (targetGroupTuple != null) {
                                            if (targetGroupTuple.getTargetGroupArn() != null) {
                                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups.member." + targetGroupsListIndex + ".TargetGroupArn", StringUtils.fromString(targetGroupTuple.getTargetGroupArn()));
                                            }
                                            if (targetGroupTuple.getWeight() != null) {
                                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups.member." + targetGroupsListIndex + ".Weight", StringUtils.fromInteger(targetGroupTuple.getWeight()));
                                            }
                                        }
                                        ++targetGroupsListIndex;
                                    }
                                }
                            }
                            if ((targetGroupStickinessConfig = forwardConfig.getTargetGroupStickinessConfig()) != null) {
                                if (targetGroupStickinessConfig.getEnabled() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroupStickinessConfig.Enabled", StringUtils.fromBoolean(targetGroupStickinessConfig.getEnabled()));
                                }
                                if (targetGroupStickinessConfig.getDurationSeconds() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroupStickinessConfig.DurationSeconds", StringUtils.fromInteger(targetGroupStickinessConfig.getDurationSeconds()));
                                }
                            }
                        }
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        if (createListenerRequest.getAlpnPolicy() != null) {
            List<String> alpnPolicyList = createListenerRequest.getAlpnPolicy();
            if (alpnPolicyList.isEmpty()) {
                request.addParameter("AlpnPolicy", "");
            } else {
                int alpnPolicyListIndex = 1;
                for (String alpnPolicyListValue : alpnPolicyList) {
                    if (alpnPolicyListValue != null) {
                        request.addParameter("AlpnPolicy.member." + alpnPolicyListIndex, StringUtils.fromString(alpnPolicyListValue));
                    }
                    ++alpnPolicyListIndex;
                }
            }
        }
        if (createListenerRequest.getTags() != null) {
            List<Tag> tagsList = createListenerRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

