/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.SubnetMapping;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    @Override
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLoadBalancerRequest> request = new DefaultRequest<CreateLoadBalancerRequest>(createLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createLoadBalancerRequest.getName()));
        }
        if (createLoadBalancerRequest.getSubnets() != null) {
            List<String> subnetsList = createLoadBalancerRequest.getSubnets();
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString(subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getSubnetMappings() != null) {
            List<SubnetMapping> subnetMappingsList = createLoadBalancerRequest.getSubnetMappings();
            if (subnetMappingsList.isEmpty()) {
                request.addParameter("SubnetMappings", "");
            } else {
                int subnetMappingsListIndex = 1;
                for (SubnetMapping subnetMappingsListValue : subnetMappingsList) {
                    if (subnetMappingsListValue != null) {
                        if (subnetMappingsListValue.getSubnetId() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".SubnetId", StringUtils.fromString(subnetMappingsListValue.getSubnetId()));
                        }
                        if (subnetMappingsListValue.getAllocationId() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".AllocationId", StringUtils.fromString(subnetMappingsListValue.getAllocationId()));
                        }
                        if (subnetMappingsListValue.getPrivateIPv4Address() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".PrivateIPv4Address", StringUtils.fromString(subnetMappingsListValue.getPrivateIPv4Address()));
                        }
                        if (subnetMappingsListValue.getIPv6Address() != null) {
                            request.addParameter("SubnetMappings.member." + subnetMappingsListIndex + ".IPv6Address", StringUtils.fromString(subnetMappingsListValue.getIPv6Address()));
                        }
                    }
                    ++subnetMappingsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getSecurityGroups() != null) {
            List<String> securityGroupsList = createLoadBalancerRequest.getSecurityGroups();
            if (securityGroupsList.isEmpty()) {
                request.addParameter("SecurityGroups", "");
            } else {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString(securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getScheme() != null) {
            request.addParameter("Scheme", StringUtils.fromString(createLoadBalancerRequest.getScheme()));
        }
        if (createLoadBalancerRequest.getTags() != null) {
            List<Tag> tagsList = createLoadBalancerRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(createLoadBalancerRequest.getType()));
        }
        if (createLoadBalancerRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString(createLoadBalancerRequest.getIpAddressType()));
        }
        if (createLoadBalancerRequest.getCustomerOwnedIpv4Pool() != null) {
            request.addParameter("CustomerOwnedIpv4Pool", StringUtils.fromString(createLoadBalancerRequest.getCustomerOwnedIpv4Pool()));
        }
        return request;
    }
}

