/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.DynamoDBTarget;

@SdkInternalApi
public class DynamoDBTargetMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<Boolean> SCANALL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanAll").build();
    private static final MarshallingInfo<Double> SCANRATE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanRate").build();
    private static final DynamoDBTargetMarshaller instance = new DynamoDBTargetMarshaller();

    public static DynamoDBTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(DynamoDBTarget dynamoDBTarget, ProtocolMarshaller protocolMarshaller) {
        if (dynamoDBTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dynamoDBTarget.getPath(), PATH_BINDING);
            protocolMarshaller.marshall(dynamoDBTarget.getScanAll(), SCANALL_BINDING);
            protocolMarshaller.marshall(dynamoDBTarget.getScanRate(), SCANRATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

