/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client;

import java.net.URL;
import org.apache.hadoop.shaded.org.eclipse.jetty.client.HttpClient;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.resource.Resource;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.apache.hadoop.shaded.org.eclipse.jetty.xml.XmlConfiguration;

class XmlBasedHttpClientProvider {
    public static final Logger LOG = Log.getLogger(XmlBasedHttpClientProvider.class);

    XmlBasedHttpClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient get(WebSocketContainerScope scope) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            return null;
        }
        URL resource = contextClassLoader.getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            Thread.currentThread().setContextClassLoader(HttpClient.class.getClassLoader());
            HttpClient httpClient = XmlBasedHttpClientProvider.newHttpClient(resource);
            return httpClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static HttpClient newHttpClient(URL resource) {
        try {
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(resource));
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t2) {
            LOG.warn("Failure to load HttpClient from XML {}", resource, t2);
            return null;
        }
    }
}

