/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import twitter4j.HttpResponse;
import twitter4j.TwitterException;
import twitter4j.auth.OAuthToken;

public class AccessToken
extends OAuthToken
implements Serializable {
    private static final long serialVersionUID = 2470022129505774772L;
    private String screenName;
    private long userId = -1L;

    AccessToken(HttpResponse res) throws TwitterException {
        this(res.asString());
    }

    AccessToken(String str) {
        super(str);
        this.screenName = this.getParameter("screen_name");
        String sUserId = this.getParameter("user_id");
        if (sUserId != null) {
            this.userId = Long.parseLong(sUserId);
        }
    }

    public AccessToken(String token, String tokenSecret) {
        super(token, tokenSecret);
        int dashIndex = token.indexOf("-");
        if (dashIndex != -1) {
            String sUserId = token.substring(0, dashIndex);
            try {
                this.userId = Long.parseLong(sUserId);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
    }

    public AccessToken(String token, String tokenSecret, long userId) {
        super(token, tokenSecret);
        this.userId = userId;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public long getUserId() {
        return this.userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.userId != that.userId) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "AccessToken{screenName='" + this.screenName + '\'' + ", userId=" + this.userId + '}';
    }
}

