/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoConnectionPoolClearedException;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class OperationContext {
    private static final AtomicLong NEXT_ID = new AtomicLong(0L);
    private final long id;
    private final ServerDeprioritization serverDeprioritization;
    private final SessionContext sessionContext;
    private final RequestContext requestContext;
    private final TimeoutContext timeoutContext;
    @Nullable
    private final ServerApi serverApi;

    public OperationContext(RequestContext requestContext, SessionContext sessionContext, TimeoutContext timeoutContext, @Nullable ServerApi serverApi) {
        this(NEXT_ID.incrementAndGet(), requestContext, sessionContext, timeoutContext, new ServerDeprioritization(), serverApi);
    }

    public static OperationContext simpleOperationContext(TimeoutSettings timeoutSettings, @Nullable ServerApi serverApi) {
        return new OperationContext(IgnorableRequestContext.INSTANCE, NoOpSessionContext.INSTANCE, new TimeoutContext(timeoutSettings), serverApi);
    }

    public static OperationContext simpleOperationContext(TimeoutContext timeoutContext) {
        return new OperationContext(IgnorableRequestContext.INSTANCE, NoOpSessionContext.INSTANCE, timeoutContext, null);
    }

    public OperationContext withSessionContext(SessionContext sessionContext) {
        return new OperationContext(this.id, this.requestContext, sessionContext, this.timeoutContext, this.serverDeprioritization, this.serverApi);
    }

    public OperationContext withTimeoutContext(TimeoutContext timeoutContext) {
        return new OperationContext(this.id, this.requestContext, this.sessionContext, timeoutContext, this.serverDeprioritization, this.serverApi);
    }

    public long getId() {
        return this.id;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public TimeoutContext getTimeoutContext() {
        return this.timeoutContext;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    public OperationContext(long id, RequestContext requestContext, SessionContext sessionContext, TimeoutContext timeoutContext, ServerDeprioritization serverDeprioritization, @Nullable ServerApi serverApi) {
        this.id = id;
        this.serverDeprioritization = serverDeprioritization;
        this.requestContext = requestContext;
        this.sessionContext = sessionContext;
        this.timeoutContext = timeoutContext;
        this.serverApi = serverApi;
    }

    public OperationContext(long id, RequestContext requestContext, SessionContext sessionContext, TimeoutContext timeoutContext, @Nullable ServerApi serverApi) {
        this.id = id;
        this.serverDeprioritization = new ServerDeprioritization();
        this.requestContext = requestContext;
        this.sessionContext = sessionContext;
        this.timeoutContext = timeoutContext;
        this.serverApi = serverApi;
    }

    public ServerDeprioritization getServerDeprioritization() {
        return this.serverDeprioritization;
    }

    public static final class ServerDeprioritization {
        @Nullable
        private ServerAddress candidate = null;
        private final Set<ServerAddress> deprioritized = new HashSet<ServerAddress>();
        private final DeprioritizingSelector selector = new DeprioritizingSelector();

        private ServerDeprioritization() {
        }

        ServerSelector getServerSelector() {
            return this.selector;
        }

        void updateCandidate(ServerAddress serverAddress) {
            this.candidate = serverAddress;
        }

        public void onAttemptFailure(Throwable failure) {
            if (this.candidate == null || failure instanceof MongoConnectionPoolClearedException) {
                this.candidate = null;
                return;
            }
            this.deprioritized.add(this.candidate);
        }

        private final class DeprioritizingSelector
        implements ServerSelector {
            private DeprioritizingSelector() {
            }

            @Override
            public List<ServerDescription> select(ClusterDescription clusterDescription) {
                List<ServerDescription> serverDescriptions = clusterDescription.getServerDescriptions();
                if (!this.isEnabled(clusterDescription.getType())) {
                    return serverDescriptions;
                }
                List nonDeprioritizedServerDescriptions = serverDescriptions.stream().filter(serverDescription -> !ServerDeprioritization.this.deprioritized.contains(serverDescription.getAddress())).collect(Collectors.toList());
                return nonDeprioritizedServerDescriptions.isEmpty() ? serverDescriptions : nonDeprioritizedServerDescriptions;
            }

            private boolean isEnabled(ClusterType clusterType) {
                return clusterType == ClusterType.SHARDED;
            }
        }
    }
}

