/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.checker;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.HiveConfEntry;
import com.dataiku.hproxy.model.hive.ValidationQuery;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.dataiku.hproxy.sandbox.hive.common.HiveColumnsUnprefixer;
import com.dataiku.hproxy.sandbox.hive.common.HiveLoaderImpl;
import com.dataiku.hproxy.sandbox.hive.common.HiveSession;
import com.dataiku.hproxy.sandbox.hive.common.ReflectedHiveCallCache;
import com.dataiku.hproxy.server.hive.checker.IHiveCheckerImpl;
import com.dataiku.hproxy.utils.HiveUtils;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.log4j.Logger;

public class HiveCheckerImpl
implements IHiveCheckerImpl {
    private ValidationQuery query;
    private boolean replacedCTAS;
    private boolean isExternal;
    private ValidationResult result = new ValidationResult();
    private int endOffset;
    private int startOffset;
    private String script;
    private HashMap<String, ValidationResult.InsertOverwriteDef> insertOverwrites = new HashMap();
    private ReflectedHiveCallCache reflect;
    private int currentLineFrom;
    private int currentLineTo;
    private HiveLoaderImpl hive;
    private Context ctx;
    private FileSystem fs;
    private static Logger logger = Logger.getLogger(HiveCheckerImpl.class);
    private boolean abortedOnHDFSFlag = false;
    private HiveSession session;
    private String tempDB;
    private int headBlankLines;
    private static Pattern errorWithPositionPrefixPattern;
    private static Pattern errorPrefixPattern;
    private static int sessionCounter;

    private String removeBackticks(String str) {
        return str.replace("`", "");
    }

    private int hiveToken(String tok) {
        return this.reflect.hiveToken(tok);
    }

    public void init(ClassLoader cl, ValidationQuery query, FileSystem fs, List<HiveConfEntry> extraConf) {
        this.reflect = new ReflectedHiveCallCache(cl);
        this.query = query;
        this.fs = fs;
    }

    private void visitTree(Tree tree, int rec, StringBuilder sb) {
        sb.append(StringUtils.repeat((String)" ", (int)rec) + tree.getText() + "(" + tree.getType() + ")\n");
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.visitTree(tree.getChild(i), rec + 1, sb);
        }
    }

    private void visitTree(Tree tree) {
        StringBuilder sb = new StringBuilder();
        this.visitTree(tree, 0, sb);
        logger.info((Object)("AST:\n" + sb.toString()));
    }

    private Exception getNiceExceptionFromErrorStream(String stream) {
        Object error = "";
        for (String errLine : StringUtils.split((String)stream, (String)"\r\n")) {
            if (errLine.trim().equals("OK")) continue;
            error = (String)error + errLine;
        }
        if (((String)error).contains("MetaException(")) {
            error = "Hive throwed a MetaException. Check the metastore?";
            this.abortOnHDFSFailure();
        }
        if (((String)error).contains("SafeModeException") && ((String)error).contains("Name node is in safe mode.")) {
            error = "Hadoop is in safemode";
            this.abortOnHDFSFailure();
        }
        return new RuntimeException((String)error);
    }

    private Tree handleCTAS(Tree tree) throws Exception {
        if (tree.getType() != this.hiveToken("TOK_CREATETABLE")) {
            return tree;
        }
        if (tree.getChildCount() < 3) {
            return tree;
        }
        if (tree.getChild(0).getType() != this.hiveToken("TOK_TABNAME")) {
            return tree;
        }
        if (this.findFirstChildWithType(tree, this.hiveToken("TOK_LIKETABLE")) == null) {
            return tree;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (tree.getChild(i).getType() != this.hiveToken("TOK_QUERY")) continue;
            if (this.findFirstChildWithType(tree, this.hiveToken("TOK_TABCOLLIST")) != null) {
                throw new Exception("CREATE TABLE AS SELECT command cannot specify the list of columns for the target table");
            }
            logger.info((Object)"Rewrite CTAS statement");
            this.replacedCTAS = true;
            return this.convertCTAStoCT(tree);
        }
        return tree;
    }

    private static ASTNode cloneAST(ASTNode original) {
        ASTNode copy = new ASTNode(original);
        int cc = original.getChildCount();
        if (cc > 0) {
            for (int i = 0; i < cc; ++i) {
                ASTNode astNode = (ASTNode)original.getChild(i);
                ASTNode astNodeCopy = HiveCheckerImpl.cloneAST(astNode);
                copy.addChild((Tree)astNodeCopy);
                astNodeCopy.setParent((Tree)copy);
            }
        }
        return copy;
    }

    private void hookOnSelect(ASTNode tree) {
        if (tree.getType() != this.hiveToken("TOK_QUERY") || tree.getChildCount() != 2 || tree.getChild(1).getType() != this.hiveToken("TOK_INSERT") || tree.getChild(0).getType() != this.hiveToken("TOK_FROM")) {
            return;
        }
        Tree insertToken = tree.getChild(1);
        if (insertToken.getChildCount() < 2 || insertToken.getChild(0).getType() != this.hiveToken("TOK_DESTINATION") || insertToken.getChild(1).getType() != this.hiveToken("TOK_SELECT")) {
            return;
        }
        Tree destinationToken = insertToken.getChild(0);
        if (destinationToken.getChildCount() != 1 || destinationToken.getChild(0).getType() != this.hiveToken("TOK_DIR") || destinationToken.getChild(0).getChildCount() != 1 || destinationToken.getChild(0).getChild(0).getType() != this.hiveToken("TOK_TMP_FILE")) {
            return;
        }
        this.emitMessage(ValidationResult.ValidationMessage.Severity.WARNING, new ErrorAndPosition("The output of this query is never used"));
    }

    private boolean hookOnInsertOverwrite(ASTNode tree) {
        String outputTableName;
        if ((tree = HiveCheckerImpl.cloneAST(tree)).getType() != this.hiveToken("TOK_QUERY") || tree.getChildCount() < 2 || tree.getChild(1).getType() != this.hiveToken("TOK_INSERT") || tree.getChild(0).getType() != this.hiveToken("TOK_FROM")) {
            return false;
        }
        Tree insertToken = tree.getChild(1);
        if (insertToken.getChildCount() < 2) {
            return false;
        }
        if (insertToken.getChild(0).getType() != this.hiveToken("TOK_DESTINATION") && insertToken.getChild(0).getType() != this.hiveToken("TOK_INSERT_INTO") || insertToken.getChild(1).getType() != this.hiveToken("TOK_SELECT") && insertToken.getChild(1).getType() != this.hiveToken("TOK_SELECTDI")) {
            return false;
        }
        Tree destinationToken = insertToken.getChild(0);
        if (destinationToken.getChildCount() != 1 || destinationToken.getChild(0).getType() != this.hiveToken("TOK_TAB") || destinationToken.getChild(0).getChild(0).getType() != this.hiveToken("TOK_TABNAME")) {
            return false;
        }
        Tree tabnameToken = destinationToken.getChild(0).getChild(0);
        if (tabnameToken.getChildCount() < 1 || tabnameToken.getChildCount() > 2) {
            return false;
        }
        if (tabnameToken.getChildCount() == 1) {
            if (tabnameToken.getChild(0).getType() != this.hiveToken("Identifier")) {
                return false;
            }
            outputTableName = tabnameToken.getChild(0).getText();
        } else {
            if (tabnameToken.getChild(0).getType() != this.hiveToken("Identifier") || tabnameToken.getChild(1).getType() != this.hiveToken("Identifier")) {
                return false;
            }
            outputTableName = tabnameToken.getChild(1).getText();
        }
        if (StringUtils.isBlank((String)outputTableName)) {
            return false;
        }
        outputTableName = this.removeBackticks(outputTableName);
        logger.info((Object)("\"INSERT [INTO|OVERWRITE] TABLE " + outputTableName + "\" statement detected"));
        ASTNode tokDir = new ASTNode((Token)new CommonToken(this.hiveToken("TOK_DIR"), "TOK_DIR"));
        ASTNode tokTmpFile = new ASTNode((Token)new CommonToken(this.hiveToken("TOK_TMP_FILE"), "TOK_TMP_FILE"));
        tokDir.addChild((Tree)tokTmpFile);
        tokTmpFile.setParent((Tree)tokDir);
        destinationToken.setChild(0, (Tree)tokDir);
        tokDir.setParent(destinationToken);
        logger.info((Object)"Rewrited tree (into normal select) :");
        this.visitTree((Tree)tree);
        BaseSemanticAnalyzer sem = null;
        try {
            sem = this.reflect.createSemanticAnalyzer(this.session.getConf(), tree);
            if (sem == null) {
                throw new RuntimeException("Failed to initialize semantic analyzer");
            }
            sem.analyze(tree, this.ctx);
        }
        catch (Exception e) {
            this.emitMessage(ValidationResult.ValidationMessage.Severity.ERROR, this.cleanupHiveError(e.getMessage()));
            logger.info((Object)"Analyze failed, but the schema \"may\" be available...", (Throwable)e);
        }
        assert (sem != null);
        List schema = sem.getResultSchema();
        if (schema == null || schema.size() == 0) {
            logger.info((Object)"The schema is empty (how did you do that?)");
            return false;
        }
        logger.info((Object)"The select part of the 'insert overwrite' statement has the following schema:");
        ValidationResult.InsertOverwriteDef def = new ValidationResult.InsertOverwriteDef();
        def.destinationTable = outputTableName;
        for (FieldSchema fs : schema) {
            ColumnSchema col = new ColumnSchema();
            col.name = fs.getName();
            col.type = fs.getType();
            col.comment = fs.getComment();
            if (col.name == null) {
                col.name = "";
            }
            if (col.type == null) {
                col.type = "";
            }
            logger.info((Object)(" > " + col.name + " " + col.type));
            def.schema.add(col);
        }
        HiveColumnsUnprefixer.unprefix(def.schema);
        this.computeCurrentLocation();
        def.lineFrom = this.currentLineFrom;
        def.lineTo = this.currentLineTo;
        this.insertOverwrites.put(outputTableName, def);
        return true;
    }

    private Tree findFirstChildWithType(Tree tree, int type) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree current = tree.getChild(i);
            if (current.getType() != type) continue;
            return current;
        }
        return null;
    }

    private ASTNode rewriteAllLocations(ASTNode tree) {
        if (tree == null) {
            return tree;
        }
        if ((tree.getToken().getType() == this.hiveToken("TOK_TABLELOCATION") || tree.getToken().getType() == this.hiveToken("TOK_PARTITIONLOCATION")) && tree.getChildCount() == 1) {
            ASTNode tok = new ASTNode((Token)new CommonToken(this.hiveToken("StringLiteral"), "'" + this.hive.getWarehouse() + "/fakelocation'"));
            tree.setChild(0, (Tree)tok);
            tok.setParent((Tree)tree);
            logger.info((Object)"Rewrite location statement");
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.rewriteAllLocations((ASTNode)tree.getChild(i));
        }
        return tree;
    }

    public void close() {
        if (this.tempDB != null) {
            if (!this.abortedOnHDFSFlag) {
                try {
                    logger.info((Object)"Drop temporary Hive DB");
                    org.apache.hadoop.hive.ql.Driver d = new org.apache.hadoop.hive.ql.Driver(this.session.getConf());
                    d.run("DROP DATABASE " + this.tempDB + " CASCADE");
                    this.tryCloseAndDestroyDriver(d);
                }
                catch (Exception e) {
                    logger.error((Object)"Error when trying to drop the temp hive db", (Throwable)e);
                }
            }
            this.tempDB = null;
        }
        if (this.session != null) {
            this.session.destroy();
            this.session = null;
        }
        if (this.hive != null) {
            this.hive.close(this.abortedOnHDFSFlag);
            this.hive = null;
        }
    }

    private ASTNode convertSchemaToTokens(List<FieldSchema> schema) throws CommandNeedRetryException, ParseException {
        Object fakeQuery = "CREATE TABLE hello_guys (";
        boolean first = true;
        for (FieldSchema fs : schema) {
            if (!first) {
                fakeQuery = (String)fakeQuery + ",";
            }
            fakeQuery = (String)fakeQuery + "`" + fs.getName() + "` " + fs.getType();
            first = false;
        }
        fakeQuery = (String)fakeQuery + ")";
        ParseDriver pd = new ParseDriver();
        ASTNode tree = pd.parse((String)fakeQuery);
        tree = this.reflect.reflectedParseUtilsFindRootNonNullToken(tree);
        this.reflect.reflectedParseUtilsHandleSetColRefs(tree, this.ctx);
        assert (tree.getType() == this.hiveToken("TOK_CREATETABLE"));
        assert (tree.getChildCount() == 3);
        assert (tree.getChild(2).getType() == this.hiveToken("TOK_TABCOLLIST"));
        return (ASTNode)tree.getChild(2);
    }

    private Tree convertCTAStoCT(Tree tree) throws Exception {
        int selectPartChildIdx = -1;
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (tree.getChild(i).getType() != this.hiveToken("TOK_QUERY")) continue;
            selectPartChildIdx = i;
        }
        ASTNode subq = (ASTNode)tree.getChild(selectPartChildIdx);
        BaseSemanticAnalyzer sem = this.reflect.createSemanticAnalyzer(this.session.getConf(), subq);
        sem.analyze(subq, this.ctx);
        sem.validate();
        List schema = sem.getResultSchema();
        ASTNode newSchemaNode = this.convertSchemaToTokens(schema);
        tree.setChild(selectPartChildIdx, (Tree)newSchemaNode);
        newSchemaNode.setParent(tree);
        return tree;
    }

    private boolean isDatabaseManipulation(Tree tree) {
        ArrayList<Integer> dmTokens = new ArrayList<Integer>();
        dmTokens.add(this.hiveToken("TOK_DROPDATABASE"));
        dmTokens.add(this.hiveToken("TOK_ALTERDATABASE_PROPERTIES"));
        return dmTokens.contains(tree.getType());
    }

    private boolean isDatabaseSelectionOrCreation(Tree tree) {
        ArrayList<Integer> dmTokens = new ArrayList<Integer>();
        dmTokens.add(this.hiveToken("TOK_CREATEDATABASE"));
        dmTokens.add(this.hiveToken("TOK_SWITCHDATABASE"));
        return dmTokens.contains(tree.getType());
    }

    private boolean canBeValidated(Tree tree) {
        if (this.isDatabaseManipulation(tree)) {
            return false;
        }
        ArrayList<Integer> allowedTokens = new ArrayList<Integer>();
        allowedTokens.add(this.hiveToken("TOK_CREATEDATABASE"));
        allowedTokens.add(this.hiveToken("TOK_SWITCHDATABASE"));
        allowedTokens.add(this.hiveToken("TOK_CREATETABLE"));
        allowedTokens.add(this.hiveToken("TOK_CREATEFUNCTION"));
        allowedTokens.add(this.hiveToken("TOK_DROPFUNCTION"));
        allowedTokens.add(this.hiveToken("TOK_DROPTABLE"));
        allowedTokens.add(this.hiveToken("TOK_QUERY"));
        allowedTokens.add(this.hiveToken("TOK_SHOWTABLES"));
        allowedTokens.add(this.hiveToken("TOK_DESCTABLE"));
        allowedTokens.add(this.hiveToken("TOK_DESCDATABASE"));
        allowedTokens.add(this.hiveToken("TOK_DESCFUNCTION"));
        allowedTokens.add(this.hiveToken("TOK_ALTERTABLE_PROPERTIES"));
        allowedTokens.add(this.hiveToken("TOK_ALTERTABLE_ADDPARTS"));
        try {
            allowedTokens.add(this.hiveToken("TOK_ALTERTABLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allowedTokens.contains(tree.getType());
    }

    private void validateCommand(String cmd) throws Exception {
        this.ctx = new Context((Configuration)this.session.getConf());
        ParseDriver pd = new ParseDriver();
        ASTNode tree = this.reflect.parseDriverParse(pd, cmd, this.ctx);
        tree = this.reflect.reflectedParseUtilsFindRootNonNullToken(tree);
        this.reflect.reflectedParseUtilsHandleSetColRefs(tree, this.ctx);
        if (this.isDatabaseManipulation((Tree)tree)) {
            logger.info((Object)"Ignored DB manipulation statement");
            this.emitMessage(ValidationResult.ValidationMessage.Severity.WARNING, new ErrorAndPosition("Hive recipes are executed in a semi-sandboxed environment. You probably don't want to manipulate databases here."));
            return;
        }
        if (this.isDatabaseSelectionOrCreation((Tree)tree)) {
            // empty if block
        }
        if (!this.canBeValidated((Tree)tree)) {
            logger.info((Object)"Cannot validate this statement:");
            this.visitTree((Tree)tree);
            this.emitMessage(ValidationResult.ValidationMessage.Severity.WARNING, new ErrorAndPosition("Although the syntax seems correct, the Hive script checker doesn't support this statement."));
            return;
        }
        logger.info((Object)"AST before transformation:");
        this.visitTree((Tree)tree);
        logger.info((Object)"Applying transformations (if any):");
        this.replacedCTAS = false;
        this.isExternal = false;
        this.hookOnSelect(tree);
        tree = (ASTNode)this.handleCTAS((Tree)tree);
        if (!this.query.useGlobalMetastore) {
            tree = this.rewriteAllLocations(tree);
        }
        if (this.replacedCTAS && this.isExternal) {
            throw new Exception("CREATE-TABLE-AS-SELECT cannot create external table");
        }
        logger.info((Object)"AST after transformation:");
        this.visitTree((Tree)tree);
        if (this.hookOnInsertOverwrite(tree) && this.query.onlyCheckInsertOverwrites) {
            return;
        }
        BaseSemanticAnalyzer sem = this.reflect.createSemanticAnalyzer(this.hive.getConf(), tree);
        sem.analyze(tree, this.ctx);
        sem.validate();
        QueryPlan qp = this.reflect.createQueryPlan(cmd, sem, this.session);
        LinkedList<Task<? extends Serializable>> runnable = new LinkedList<Task<? extends Serializable>>();
        DriverContext dctx = this.reflect.createDriverContext(runnable, this.ctx, sem);
        runnable.addAll(sem.getRootTasks());
        logger.info((Object)"Task list:");
        while (runnable.peek() != null) {
            Task tsk = (Task)runnable.remove();
            logger.info((Object)("-Task name: " + tsk.getName() + "[" + tsk.getClass().getSimpleName() + "]"));
            String tskClassName = tsk.getClass().getCanonicalName();
            boolean isDDLTask = false;
            if ("org.apache.hadoop.hive.ql.exec.DDLTask".equals(tskClassName)) {
                isDDLTask = true;
            }
            if ("org.apache.hadoop.hive.ql.ddl.DDLTask".equals(tskClassName)) {
                isDDLTask = true;
            }
            if ("org.apache.hadoop.hive.ql.exec.FunctionTask".equals(tskClassName)) {
                isDDLTask = true;
            }
            if (isDDLTask) {
                logger.info((Object)" > execute");
                int code = this.reflect.executeTask(sem, this.session, (Task<? extends Serializable>)tsk, this.hive.getConf(), this.ctx, dctx, qp);
                if (code == 0) continue;
                throw this.getNiceExceptionFromErrorStream(this.session.getErrorStreamAsString());
            }
            logger.info((Object)" > ignore");
        }
        logger.info((Object)"No more task!");
    }

    private void processCommand(String cmd) throws Exception {
        CommandProcessor p;
        logger.info((Object)("Processing command (before substitution) : " + cmd));
        cmd = this.reflect.createVariableSubstitution().substitute(this.session.getConf(), cmd);
        logger.info((Object)("Processing command (after substitution) : " + cmd));
        String cmd_trimmed = cmd.trim();
        String[] tokens = cmd_trimmed.split("\\s+");
        if (StringUtils.isWhitespace((String)cmd_trimmed) || cmd_trimmed.isEmpty()) {
            logger.info((Object)"This command is empty => ignore it");
            return;
        }
        String cmd1 = cmd_trimmed.substring(tokens[0].length()).trim();
        logger.info((Object)("First token is : " + tokens[0]));
        try {
            p = CommandProcessorFactory.get((String)tokens[0]);
        }
        catch (NoSuchMethodError e) {
            p = CommandProcessorFactory.get((String[])tokens, (HiveConf)this.session.getConf());
        }
        logger.info((Object)("Processor selected by Hive : " + p.getClass().getSimpleName()));
        boolean isADriver = false;
        if (p instanceof org.apache.hadoop.hive.ql.Driver) {
            isADriver = true;
        } else {
            for (Class<?> clazz : p.getClass().getInterfaces()) {
                if (!clazz.getName().equals("org.apache.hadoop.hive.ql.IDriver")) continue;
                isADriver = true;
            }
        }
        if (isADriver) {
            Method getResultsMethod = p.getClass().getMethod("getResults", List.class);
            Method closeMethod = p.getClass().getMethod("close", new Class[0]);
            Method destroyMethod = p.getClass().getMethod("destroy", new Class[0]);
            if (this.query.isExplainPlan && "explain".equalsIgnoreCase(tokens[0])) {
                logger.info((Object)"Execute the explain plan using the Hive's processor");
                ReflectedHiveCallCache.CommandProcessorResponseOrError resp = this.reflect.commandProcessorRun(p, cmd_trimmed);
                if (resp.error != null) {
                    if (StringUtils.isBlank((String)resp.error.getMessage())) {
                        throw this.getNiceExceptionFromErrorStream(this.session.getErrorStreamAsString());
                    }
                    throw new RuntimeException(resp.error.getMessage());
                }
                getResultsMethod.invoke((Object)p, this.result.plan);
            } else {
                closeMethod.invoke((Object)p, new Object[0]);
                destroyMethod.invoke((Object)p, new Object[0]);
                logger.info((Object)"Switch to our custom Driver");
                this.validateCommand(cmd);
            }
        } else {
            logger.info((Object)"Execute the command using the Hive's processor");
            ReflectedHiveCallCache.CommandProcessorResponseOrError resp = this.reflect.commandProcessorRun(p, cmd1);
            if (resp.error != null) {
                if (StringUtils.isBlank((String)resp.error.getMessage())) {
                    throw this.getNiceExceptionFromErrorStream(this.session.getErrorStreamAsString());
                }
                throw new RuntimeException(resp.error.getMessage());
            }
        }
        logger.info((Object)"Command processed");
    }

    private void computeCurrentLocation() {
        if (this.script != null) {
            int startOffsetTrimmed;
            int endOffsetTrimmed = this.endOffset;
            for (startOffsetTrimmed = this.startOffset; startOffsetTrimmed < this.script.length() && StringUtils.isWhitespace((String)this.script.substring(startOffsetTrimmed, startOffsetTrimmed + 1)); ++startOffsetTrimmed) {
            }
            while (endOffsetTrimmed > 0 && StringUtils.isWhitespace((String)this.script.substring(endOffsetTrimmed - 1, endOffsetTrimmed))) {
                --endOffsetTrimmed;
            }
            this.currentLineFrom = this.headBlankLines + HiveCheckerImpl.convertOffsetToLine(this.script, Math.min(this.script.length() - 1, startOffsetTrimmed));
            this.currentLineTo = this.headBlankLines + HiveCheckerImpl.convertOffsetToLine(this.script, Math.min(this.script.length() - 1, endOffsetTrimmed));
        } else {
            this.currentLineFrom = 0;
            this.currentLineTo = 100000;
        }
    }

    private void emitMessage(ValidationResult.ValidationMessage.Severity severity, ErrorAndPosition errStr) {
        logger.info((Object)("Emitted message (" + String.valueOf(severity) + ") : " + String.valueOf(errStr)));
        ValidationResult.ValidationMessage msg = new ValidationResult.ValidationMessage();
        msg.errorMessage = errStr.message;
        msg.severity = severity;
        this.computeCurrentLocation();
        msg.errorLineFrom = this.currentLineFrom;
        msg.errorLineTo = this.currentLineTo;
        if (errStr.hasPosition) {
            msg.errorLineFrom = this.currentLineFrom + errStr.line - 1;
            msg.column = errStr.column;
        }
        for (ValidationResult.ValidationMessage vm : this.result.messages) {
            if (!vm.equals((Object)msg)) continue;
            return;
        }
        this.result.messages.add(msg);
    }

    private void abortOnHDFSFailure() {
        this.abortedOnHDFSFlag = true;
        logger.error((Object)"Hive validation aborted because we detected something wrong with the HDFS (safemode, connection problem)");
    }

    private void processScript(String script) {
        int headBlankLines;
        script = HiveUtils.stripComments((String)script);
        for (headBlankLines = 0; headBlankLines < script.length() && script.charAt(headBlankLines) == '\n'; ++headBlankLines) {
        }
        script = script.substring(headBlankLines);
        this.headBlankLines = headBlankLines;
        logger.info((Object)("Process a Hive script : \n" + script));
        int endOffset = 0;
        this.script = script;
        for (String command : HiveUtils.splitCommandsRemoveEscaping((String)script)) {
            if (this.abortedOnHDFSFlag) {
                logger.info((Object)"Aborted script processing (HDFS error flag is on)");
                break;
            }
            this.startOffset = endOffset;
            this.endOffset = (endOffset += command.length() + 1) - 1;
            if (command.trim().isEmpty()) continue;
            try {
                this.processCommand(command);
            }
            catch (ConnectException e) {
                logger.error((Object)"Caught a ConnectException ", (Throwable)e);
                this.emitMessage(ValidationResult.ValidationMessage.Severity.ERROR, new ErrorAndPosition("Problem with Hadoop (cannot connect to HDFS)"));
                this.abortOnHDFSFailure();
            }
            catch (Exception e) {
                ErrorAndPosition hiveError = this.cleanupHiveError(e.getMessage());
                this.emitMessage(ValidationResult.ValidationMessage.Severity.ERROR, hiveError);
                logger.error((Object)"Error in Hive script ", (Throwable)e);
            }
            if (this.ctx == null) continue;
            try {
                this.ctx.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
        this.script = null;
        logger.info((Object)"Script processed");
    }

    private ErrorAndPosition cleanupHiveError(String hiveError) {
        if (!StringUtils.isBlank((String)hiveError)) {
            Matcher matcher = errorPrefixPattern.matcher(hiveError);
            if (matcher.find()) {
                String errorInfo = matcher.group(1);
                hiveError = matcher.replaceFirst("");
                hiveError = StringUtils.capitalize((String)hiveError);
                Matcher positionMatcher = errorWithPositionPrefixPattern.matcher(errorInfo);
                if (positionMatcher.matches()) {
                    int line = Integer.parseInt(positionMatcher.group(1));
                    int column = Integer.parseInt(positionMatcher.group(2));
                    return new ErrorAndPosition(hiveError, line, column);
                }
                return new ErrorAndPosition(hiveError);
            }
            hiveError = StringUtils.capitalize((String)hiveError);
            return new ErrorAndPosition(hiveError);
        }
        return new ErrorAndPosition("Unknown Hive error");
    }

    public ValidationResult checkCompile() {
        logger.info((Object)"Initialization");
        try {
            this.hive = HiveLoaderImpl.initTunedHiveForChecking(this.fs, this.query.extraConf, this.query.useGlobalMetastore);
            Thread.currentThread().setContextClassLoader(this.hive.getClassLoader());
            this.reflect = new ReflectedHiveCallCache(this.hive.getClassLoader());
            this.session = HiveSession.initSession(this.hive);
            this.createTempDB();
        }
        catch (ConnectException e) {
            logger.error((Object)"Caught a ConnectException in initailization: ", (Throwable)e);
            this.abortOnHDFSFailure();
            this.emitMessage(ValidationResult.ValidationMessage.Severity.ERROR, new ErrorAndPosition("Problem with Hadoop (cannot connect to HDFS)"));
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected error in initialization", (Throwable)e);
            this.abortOnHDFSFailure();
            this.emitMessage(ValidationResult.ValidationMessage.Severity.ERROR, new ErrorAndPosition("An error occurred during the initialization of the Hive validator"));
        }
        logger.info((Object)"Process initialization script...");
        this.processScript(this.query.initQuery);
        this.result.ok = true;
        for (ValidationResult.ValidationMessage validationMessage : this.result.messages) {
            if (validationMessage.severity != ValidationResult.ValidationMessage.Severity.ERROR) continue;
            this.result.ok = false;
            validationMessage.errorLineFrom = 0;
            validationMessage.errorLineTo = 100000;
            validationMessage.errorMessage = "Internal error in the Dataiku's initialization script : " + validationMessage.errorMessage;
        }
        if (this.result.ok) {
            logger.info((Object)"Process user script...");
            this.processScript(this.query.userQuery);
            for (ValidationResult.ValidationMessage validationMessage : this.result.messages) {
                if (validationMessage.severity != ValidationResult.ValidationMessage.Severity.ERROR) continue;
                this.result.ok = false;
                break;
            }
        }
        logger.info((Object)"End of Hive recipe validation");
        logger.info((Object)"Summary : ");
        logger.info((Object)(" > " + this.insertOverwrites.size() + " iodef(s)"));
        logger.info((Object)(" > " + this.insertOverwrites.size() + " messages(s)"));
        for (Map.Entry entry : this.insertOverwrites.entrySet()) {
            this.result.insertOverwrites.add((ValidationResult.InsertOverwriteDef)entry.getValue());
        }
        return this.result;
    }

    private static synchronized String generateID() {
        return "HS" + sessionCounter++;
    }

    private void createTempDB() throws CommandNeedRetryException {
        this.tempDB = "tmpdb_" + HiveCheckerImpl.generateID();
        org.apache.hadoop.hive.ql.Driver d = this.session.newDriver();
        d.run("CREATE DATABASE " + this.tempDB);
        this.tryCloseAndDestroyDriver(d);
        d = this.session.newDriver();
        d.run("USE " + this.tempDB);
        this.tryCloseAndDestroyDriver(d);
    }

    private void tryCloseAndDestroyDriver(org.apache.hadoop.hive.ql.Driver d) {
        try {
            d.close();
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)("Driver does nopt support close " + e.getMessage()));
        }
        d.destroy();
    }

    private static int convertOffsetToLine(String s, int offset) {
        LineNumberReader lnr = new LineNumberReader(new StringReader(s));
        try {
            lnr.skip(offset);
        }
        catch (IOException e) {
            return -1;
        }
        return lnr.getLineNumber();
    }

    static {
        try {
            String jdbcUrl = "jdbc:derby:memory:hive_check_metastore;create=true";
            Properties props = new Properties();
            Driver driver = DriverManager.getDriver(jdbcUrl);
            assert (driver != null);
            try {
                logger.info((Object)("Driver version " + driver.getMajorVersion() + "." + driver.getMinorVersion()));
            }
            catch (Exception ex) {
                logger.warn((Object)("Failed to get info from driver : " + ex.getMessage()));
            }
            driver.connect(jdbcUrl, props);
        }
        catch (SQLException e) {
            logger.error((Object)"Cannot create the Derby in memory database", (Throwable)e);
        }
        errorWithPositionPrefixPattern = Pattern.compile("line\\s*([0-9]+):([0-9]+)\\s*", 2);
        errorPrefixPattern = Pattern.compile("^\\s*(line\\s*[0-9]+:[0-9]+\\s*|FAILED:\\s*)+", 2);
        sessionCounter = 1000;
    }

    private static class ErrorAndPosition {
        String message;
        boolean hasPosition;
        int line;
        int column;

        public ErrorAndPosition(String message) {
            this.message = message;
            this.hasPosition = false;
        }

        public ErrorAndPosition(String message, int line, int column) {
            this.message = message;
            this.hasPosition = true;
            this.line = line;
            this.column = column;
        }
    }
}

