/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.codahale.metrics.json.MetricsModule;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.utils.DKULogger;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;

public class DKUDebugUtils {
    private static final int MAX_FRAMES = 2000;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.debug");

    public static void printAllStacks(Writer wr) throws IOException {
        ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : tmx.dumpAllThreads(true, true)) {
            wr.write(DKUDebugUtils.threadInfoToString(ti));
            wr.write("\n");
        }
    }

    public static String threadInfoToString(ThreadInfo ti) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " " + String.valueOf((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < ti.getStackTrace().length && i < 2000; ++i) {
            StackTraceElement ste = ti.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(ti.getLockInfo()).append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(ti.getLockInfo()).append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : ti.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo).append('\n');
            }
        }
        if (i < ti.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = ti.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo).append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static void printMetrics(OutputStream os, boolean forceGCFirst) throws JsonGenerationException, JsonMappingException, IOException {
        if (forceGCFirst) {
            logger.info((Object)"Requested forced GC");
            Runtime.getRuntime().gc();
        }
        ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
        om.writerWithDefaultPrettyPrinter().writeValue(os, (Object)DSSMetrics.registry());
    }
}

