/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.apache.log4j.Logger;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.CLibrary;
import org.jvnet.libpam.impl.PAMLibrary;

public class PAM {
    private PAMLibrary.pam_handle_t pht;
    private PAMLibrary.pam_conv conv = new PAMLibrary.pam_conv(new PAMLibrary.pam_conv.PamCallback(){

        @Override
        public int callback(int num_msg, Pointer msg, Pointer resp, Pointer __) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("pam_conv num_msg=" + num_msg));
            }
            if (PAM.this.password == null) {
                return 6;
            }
            Pointer m = CLibrary.libc.calloc(PAMLibrary.pam_response.SIZE, num_msg);
            resp.setPointer(0L, m);
            for (int i = 0; i < num_msg; ++i) {
                PAMLibrary.pam_message pm = new PAMLibrary.pam_message(msg.getPointer((long)(Native.POINTER_SIZE * i)));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(pm.msg_style + ":" + pm.msg));
                }
                if (pm.msg_style != 1) continue;
                PAMLibrary.pam_response r = new PAMLibrary.pam_response(m.share((long)(PAMLibrary.pam_response.SIZE * i)));
                r.setResp(PAM.this.password);
                r.write();
            }
            return 0;
        }
    });
    private int ret;
    private String password;
    private static final Logger LOGGER = Logger.getLogger((String)PAM.class.getName());

    public PAM(String serviceName) throws PAMException {
        PointerByReference phtr = new PointerByReference();
        this.check(PAMLibrary.libpam.pam_start(serviceName, null, this.conv, phtr), "pam_start failed");
        this.pht = new PAMLibrary.pam_handle_t(phtr.getValue());
    }

    private void check(int ret, String msg) throws PAMException {
        this.ret = ret;
        if (ret != 0) {
            if (this.pht != null) {
                throw new PAMException(msg + " : " + PAMLibrary.libpam.pam_strerror(this.pht, ret));
            }
            throw new PAMException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String username, String password) throws PAMException {
        this.password = password;
        try {
            String userName;
            this.check(PAMLibrary.libpam.pam_set_item(this.pht, 2, username), "pam_set_item failed");
            this.check(PAMLibrary.libpam.pam_authenticate(this.pht, 0), "pam_authenticate failed");
            this.check(PAMLibrary.libpam.pam_setcred(this.pht, 0), "pam_setcred failed");
            this.check(PAMLibrary.libpam.pam_acct_mgmt(this.pht, 0), "pam_acct_mgmt failed");
            PointerByReference r = new PointerByReference();
            this.check(PAMLibrary.libpam.pam_get_item(this.pht, 2, r), "pam_get_item failed");
            String string = userName = r.getValue().getString(0L);
            return string;
        }
        finally {
            this.password = null;
        }
    }

    public void dispose() {
        if (this.pht != null) {
            PAMLibrary.libpam.pam_end(this.pht, this.ret);
            this.pht = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

