/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.validators;

import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.claims.CodeHash;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.validators.InvalidHashException;
import com.dataiku.dss.shadelib.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AuthorizationCodeValidator {
    public static void validate(AuthorizationCode code, JWSAlgorithm jwsAlgorithm, CodeHash codeHash) throws InvalidHashException {
        CodeHash expectedHash = CodeHash.compute(code, jwsAlgorithm);
        if (expectedHash == null) {
            throw InvalidHashException.INVALID_CODE_HASH_EXCEPTION;
        }
        if (!expectedHash.equals(codeHash)) {
            throw InvalidHashException.INVALID_CODE_HASH_EXCEPTION;
        }
    }
}

