/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.models.utils;

import com.dataiku.dss.shadelib.io.swagger.models.ArrayModel;
import com.dataiku.dss.shadelib.io.swagger.models.ComposedModel;
import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.ModelImpl;
import com.dataiku.dss.shadelib.io.swagger.models.RefModel;
import com.dataiku.dss.shadelib.io.swagger.models.Xml;
import com.dataiku.dss.shadelib.io.swagger.models.properties.AbstractNumericProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.ArrayProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.MapProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.ObjectProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.Property;
import com.dataiku.dss.shadelib.io.swagger.models.properties.PropertyBuilder;
import com.dataiku.dss.shadelib.io.swagger.models.properties.RefProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyModelConverter {
    public Property modelToProperty(Model model) {
        if (model instanceof ModelImpl) {
            ModelImpl m4 = (ModelImpl)model;
            if (m4.getAdditionalProperties() != null) {
                MapProperty mapProperty = new MapProperty();
                mapProperty.setType(m4.getType());
                mapProperty.setAllowEmptyValue(m4.getAllowEmptyValue());
                mapProperty.setDefault((String)m4.getDefaultValue());
                mapProperty.setDescription(m4.getDescription());
                mapProperty.setExample(m4.getExample());
                mapProperty.setFormat(m4.getFormat());
                mapProperty.setName(m4.getName());
                mapProperty.setTitle(m4.getTitle());
                List<String> required = m4.getRequired();
                if (required != null) {
                    for (String name : required) {
                        if (!name.equals(m4.getName())) continue;
                        mapProperty.setRequired(true);
                    }
                }
                mapProperty.setXml(m4.getXml());
                mapProperty.setVendorExtensions(m4.getVendorExtensions());
                mapProperty.setAdditionalProperties(m4.getAdditionalProperties());
                return mapProperty;
            }
            Property property = this.propertyByType(m4);
            if (property instanceof ObjectProperty) {
                ObjectProperty objectProperty = (ObjectProperty)property;
                objectProperty.setProperties(model.getProperties());
                objectProperty.setExample(model.getExample());
                return objectProperty;
            }
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                ModelImpl modelImpl = (ModelImpl)model;
                stringProperty.setPattern(modelImpl.getPattern());
                stringProperty.setMaxLength(modelImpl.getMaxLength());
                stringProperty.setMinLength(modelImpl.getMinLength());
                return stringProperty;
            }
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
                ModelImpl modelImpl = (ModelImpl)model;
                numericProperty.setMaximum(modelImpl.getMaximum());
                numericProperty.setMinimum(modelImpl.getMinimum());
                numericProperty.setMultipleOf(modelImpl.getMultipleOf());
                numericProperty.setExclusiveMinimum(modelImpl.getExclusiveMinimum());
                numericProperty.setExclusiveMaximum(modelImpl.getExclusiveMaximum());
                return numericProperty;
            }
            return property;
        }
        if (model instanceof ArrayModel) {
            ArrayModel m5 = (ArrayModel)model;
            ArrayProperty property = new ArrayProperty();
            Property inner = m5.getItems();
            property.setItems(inner);
            property.setExample(m5.getExample());
            property.setMaxItems(m5.getMaxItems());
            property.setMinItems(m5.getMinItems());
            property.setDescription(m5.getDescription());
            property.setTitle(m5.getTitle());
            property.setUniqueItems(m5.getUniqueItems());
            property.setXml(m5.getXml());
            return property;
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            RefProperty refProperty = new RefProperty(ref.get$ref(), ref.getRefFormat());
            return refProperty;
        }
        if (model instanceof ComposedModel) {
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.setDescription(model.getDescription());
            objectProperty.setTitle(model.getTitle());
            objectProperty.setExample(model.getExample());
            ComposedModel cm = (ComposedModel)model;
            HashSet<String> requiredProperties = new HashSet<String>();
            for (Model item : cm.getAllOf()) {
                Property itemProperty = this.modelToProperty(item);
                if (itemProperty instanceof RefProperty) {
                    RefProperty refProperty = (RefProperty)itemProperty;
                    objectProperty.property(refProperty.getSimpleRef(), itemProperty);
                    continue;
                }
                if (!(itemProperty instanceof ObjectProperty)) continue;
                ObjectProperty itemPropertyObject = (ObjectProperty)itemProperty;
                if (itemPropertyObject.getProperties() != null) {
                    for (String key : itemPropertyObject.getProperties().keySet()) {
                        objectProperty.property(key, itemPropertyObject.getProperties().get(key));
                    }
                }
                if (itemPropertyObject.getRequiredProperties() == null) continue;
                for (String req : itemPropertyObject.getRequiredProperties()) {
                    requiredProperties.add(req);
                }
            }
            if (requiredProperties.size() > 0) {
                objectProperty.setRequiredProperties(new ArrayList<String>(requiredProperties));
            }
            if (cm.getVendorExtensions() != null) {
                for (String key : cm.getVendorExtensions().keySet()) {
                    objectProperty.vendorExtension(key, cm.getVendorExtensions().get(key));
                }
            }
            return objectProperty;
        }
        return null;
    }

    private Property propertyByType(ModelImpl model) {
        return PropertyBuilder.build(model.getType(), model.getFormat(), this.argsFromModel(model));
    }

    private Map<PropertyBuilder.PropertyId, Object> argsFromModel(ModelImpl model) {
        if (model == null) {
            return Collections.emptyMap();
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args2 = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args2.put(PropertyBuilder.PropertyId.DESCRIPTION, model.getDescription());
        args2.put(PropertyBuilder.PropertyId.EXAMPLE, model.getExample());
        args2.put(PropertyBuilder.PropertyId.ENUM, model.getEnum());
        args2.put(PropertyBuilder.PropertyId.TITLE, model.getTitle());
        args2.put(PropertyBuilder.PropertyId.DEFAULT, model.getDefaultValue());
        args2.put(PropertyBuilder.PropertyId.DESCRIMINATOR, model.getDiscriminator());
        args2.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, model.getUniqueItems());
        args2.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, model.getVendorExtensions());
        args2.put(PropertyBuilder.PropertyId.PATTERN, model.getPattern());
        args2.put(PropertyBuilder.PropertyId.MAXIMUM, model.getMaximum());
        args2.put(PropertyBuilder.PropertyId.MINIMUM, model.getMinimum());
        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, model.getExclusiveMaximum());
        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, model.getExclusiveMinimum());
        args2.put(PropertyBuilder.PropertyId.MULTIPLE_OF, model.getMultipleOf());
        args2.put(PropertyBuilder.PropertyId.MIN_LENGTH, model.getMinLength());
        args2.put(PropertyBuilder.PropertyId.MAX_LENGTH, model.getMaxLength());
        return args2;
    }

    public Model propertyToModel(Property property) {
        String description = property.getDescription();
        String type = property.getType();
        String format = property.getFormat();
        Object example = null;
        Boolean allowEmptyValue = property.getAllowEmptyValue();
        if (property instanceof RefProperty) {
            RefProperty ref = (RefProperty)property;
            RefModel refModel = new RefModel(ref.getOriginalRef(), ref.getRefFormat());
            return refModel;
        }
        Map<String, Object> extensions = property.getVendorExtensions();
        Property additionalProperties = null;
        if (property instanceof MapProperty) {
            additionalProperties = ((MapProperty)property).getAdditionalProperties();
        }
        String name = property.getName();
        Xml xml = property.getXml();
        Map<String, Property> properties = null;
        if (property instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)property;
            properties = objectProperty.getProperties();
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            ArrayModel arrayModel = new ArrayModel();
            arrayModel.setItems(arrayProperty.getItems());
            arrayModel.setDescription(description);
            arrayModel.setExample(example);
            arrayModel.setUniqueItems(arrayProperty.getUniqueItems());
            if (extensions != null) {
                arrayModel.setVendorExtensions(extensions);
            }
            if (properties != null) {
                arrayModel.setProperties(properties);
            }
            return arrayModel;
        }
        ModelImpl model = new ModelImpl();
        model.setDescription(description);
        model.setExample(property.getExample());
        model.setName(name);
        model.setXml(xml);
        model.setType(type);
        model.setFormat(format);
        model.setAllowEmptyValue(allowEmptyValue);
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            model.setPattern(stringProperty.getPattern());
            model.setMinLength(stringProperty.getMinLength());
            model.setMaxLength(stringProperty.getMaxLength());
            model.setEnum(stringProperty.getEnum());
        }
        if (property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
            model.setMaximum(numericProperty.getMaximum());
            model.setMinimum(numericProperty.getMinimum());
            model.setExclusiveMaximum(numericProperty.getExclusiveMaximum());
            model.setExclusiveMinimum(numericProperty.getExclusiveMinimum());
            model.setMultipleOf(numericProperty.getMultipleOf());
        }
        if (extensions != null) {
            model.setVendorExtensions(extensions);
        }
        if (additionalProperties != null) {
            model.setAdditionalProperties(additionalProperties);
        }
        if (properties != null) {
            model.setProperties(properties);
        }
        return model;
    }
}

