/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.store;

import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.FilterDirectory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IOContext;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexOutput;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Lock;
import java.io.IOException;
import java.util.Collection;

public final class LockValidatingDirectoryWrapper
extends FilterDirectory {
    private final Lock writeLock;

    public LockValidatingDirectoryWrapper(Directory in, Lock writeLock) {
        super(in);
        this.writeLock = writeLock;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.writeLock.ensureValid();
        this.in.deleteFile(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        return this.in.createOutput(name, context);
    }

    @Override
    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        this.in.copyFrom(from, src, dest, context);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.writeLock.ensureValid();
        this.in.rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.writeLock.ensureValid();
        this.in.syncMetaData();
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.writeLock.ensureValid();
        this.in.sync(names);
    }
}

