/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRefBuilder;

public final class ToStringUtils {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private ToStringUtils() {
    }

    public static void byteArray(StringBuilder buffer, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append("b[").append(i).append("]=").append(bytes[i]);
            if (i >= bytes.length - 1) continue;
            buffer.append(',');
        }
    }

    public static String longHex(long x) {
        char[] asHex = new char[16];
        int i = 16;
        while (--i >= 0) {
            asHex[i] = HEX[(int)x & 0xF];
            x >>>= 4;
        }
        return "0x" + new String(asHex);
    }

    public static String bytesRefToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (AssertionError | RuntimeException t2) {
            return b.toString();
        }
    }

    public static String bytesRefToString(BytesRefBuilder b) {
        return ToStringUtils.bytesRefToString(b.get());
    }

    public static String bytesRefToString(byte[] b) {
        return ToStringUtils.bytesRefToString(new BytesRef(b));
    }
}

