/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AbstractDiscoverableAnnotationHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.AnnotationParser;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations.WebFilterAnnotation;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFilterAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebFilterAnnotationHandler.class);

    public WebFilterAnnotationHandler(WebAppContext context) {
        super(context);
    }

    @Override
    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        WebFilterAnnotation wfAnnotation = new WebFilterAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(wfAnnotation);
    }

    @Override
    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for fields: {}.{}", (Object)info.getClassInfo().getClassName(), (Object)info.getFieldName());
    }

    @Override
    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebFilter".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebFilter not applicable for methods: {}.{} {}", new Object[]{info.getClassInfo().getClassName(), info.getMethodName(), info.getSignature()});
    }
}

