/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.MatchedResource;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.PathSpec;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.pathmap.PathSpecGroup;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import java.util.Map;

@ManagedObject(value="Mapped Resource")
public class MappedResource<E>
implements Comparable<MappedResource<E>>,
Map.Entry<PathSpec, E> {
    private final PathSpec pathSpec;
    private final E resource;
    private final MatchedResource<E> preMatched;

    public MappedResource(PathSpec pathSpec, E resource) {
        this.pathSpec = pathSpec;
        this.resource = resource;
        this.preMatched = switch (pathSpec.getGroup()) {
            case PathSpecGroup.ROOT -> new MatchedResource<E>(resource, pathSpec, pathSpec.matched("/"));
            case PathSpecGroup.EXACT -> new MatchedResource<E>(resource, pathSpec, pathSpec.matched(pathSpec.getDeclaration()));
            default -> null;
        };
    }

    public MatchedResource<E> getPreMatched() {
        return this.preMatched;
    }

    @Override
    public int compareTo(MappedResource<E> other) {
        return this.pathSpec.compareTo(other.pathSpec);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappedResource other = (MappedResource)obj;
        return !(this.pathSpec == null ? other.pathSpec != null : !this.pathSpec.equals(other.pathSpec));
    }

    @Override
    public PathSpec getKey() {
        return this.getPathSpec();
    }

    @Override
    public E getValue() {
        return this.getResource();
    }

    @Override
    public E setValue(E value) {
        throw new UnsupportedOperationException();
    }

    @ManagedAttribute(value="path spec", readonly=true)
    public PathSpec getPathSpec() {
        return this.pathSpec;
    }

    @ManagedAttribute(value="resource", readonly=true)
    public E getResource() {
        return this.resource;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pathSpec == null ? 0 : this.pathSpec.hashCode());
        return result;
    }

    public String toString() {
        return String.format("MappedResource[pathSpec=%s,resource=%s]", this.pathSpec, this.resource);
    }
}

