/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.io.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Pool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;

public class CompoundPool<P>
implements Pool<P> {
    private final Pool<P> primaryPool;
    private final Pool<P> secondaryPool;

    public CompoundPool(Pool<P> primaryPool, Pool<P> secondaryPool) {
        this.primaryPool = primaryPool;
        this.secondaryPool = secondaryPool;
    }

    public Pool<P> getPrimaryPool() {
        return this.primaryPool;
    }

    public Pool<P> getSecondaryPool() {
        return this.secondaryPool;
    }

    @Override
    public Pool.Entry<P> reserve() {
        Pool.Entry<P> primary = this.primaryPool.reserve();
        return primary != null ? primary : this.secondaryPool.reserve();
    }

    @Override
    public Pool.Entry<P> acquire() {
        Pool.Entry<P> primary = this.primaryPool.acquire();
        return primary != null ? primary : this.secondaryPool.acquire();
    }

    @Override
    public boolean isTerminated() {
        return this.primaryPool.isTerminated();
    }

    @Override
    public Collection<Pool.Entry<P>> terminate() {
        ArrayList<Pool.Entry<P>> entries = new ArrayList<Pool.Entry<P>>();
        entries.addAll(this.primaryPool.terminate());
        entries.addAll(this.secondaryPool.terminate());
        return entries;
    }

    @Override
    public int size() {
        return this.primaryPool.size() + this.secondaryPool.size();
    }

    @Override
    public int getMaxSize() {
        return this.primaryPool.getMaxSize() + this.secondaryPool.getMaxSize();
    }

    @Override
    public Stream<Pool.Entry<P>> stream() {
        return Stream.concat(this.primaryPool.stream(), this.secondaryPool.stream());
    }

    @Override
    public int getReservedCount() {
        return this.primaryPool.getReservedCount() + this.secondaryPool.getReservedCount();
    }

    @Override
    public int getIdleCount() {
        return this.primaryPool.getIdleCount() + this.secondaryPool.getIdleCount();
    }

    @Override
    public int getInUseCount() {
        return this.primaryPool.getInUseCount() + this.secondaryPool.getInUseCount();
    }

    @Override
    public int getTerminatedCount() {
        return this.primaryPool.getTerminatedCount() + this.secondaryPool.getTerminatedCount();
    }
}

